/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.filter.BinaryLogicAbstract;
import org.geotools.filter.Filter;
import org.geotools.filter.LogicFilter;
import org.geotools.util.logging.Logging;
import org.opengis.filter.And;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.Or;

public abstract class LogicFilterImpl
extends BinaryLogicAbstract
implements LogicFilter {
    private static final Logger LOGGER = Logging.getLogger("org.geotools.core");

    protected LogicFilterImpl(FilterFactory factory) {
        this(factory, new ArrayList());
    }

    protected LogicFilterImpl(FilterFactory factory, List children) {
        super(factory, children);
    }

    @Override
    public Filter or(org.opengis.filter.Filter filter) {
        if (this.filterType == 1) {
            if (filter instanceof Or) {
                Or more = (Or)filter;
                this.children.addAll(more.getChildren());
            } else {
                this.children.add(filter);
            }
            return this;
        }
        return super.or(filter);
    }

    @Override
    public Filter and(org.opengis.filter.Filter filter) {
        if (this.filterType == 2) {
            if (filter instanceof And) {
                And more = (And)filter;
                this.children.addAll(more.getChildren());
            } else {
                this.children.add(filter);
            }
            return this;
        }
        return super.and(filter);
    }

    @Override
    public Filter not() {
        if (this.filterType == 3) {
            return (Filter)this.children.get(0);
        }
        return super.not();
    }

    List getSubFilters() {
        return this.children;
    }

    public String toString() {
        String returnString = "[";
        String operator = "";
        Iterator iterator = this.children.iterator();
        if (this.filterType == 1) {
            operator = " OR ";
        } else if (this.filterType == 2) {
            operator = " AND ";
        } else if (this.filterType == 3) {
            return "[ NOT " + iterator.next().toString() + " ]";
        }
        while (iterator.hasNext()) {
            returnString = returnString + iterator.next().toString();
            if (!iterator.hasNext()) continue;
            returnString = returnString + operator;
        }
        return returnString + "]";
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            LogicFilterImpl logFilter = (LogicFilterImpl)obj;
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("filter type match:" + (logFilter.getFilterType() == this.filterType));
                LOGGER.finest("same size:" + (logFilter.getSubFilters().size() == this.children.size()) + "; inner size: " + logFilter.getSubFilters().size() + "; outer size: " + this.children.size());
                LOGGER.finest("contains:" + logFilter.getSubFilters().containsAll(this.children));
            }
            return logFilter.getFilterType() == this.filterType && logFilter.getSubFilters().size() == this.children.size() && logFilter.getSubFilters().containsAll(this.children);
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.filterType;
        result = 37 * result + ((Object)this.children).hashCode();
        return result;
    }

    @Override
    public abstract Object accept(FilterVisitor var1, Object var2);
}

