/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import com.vividsolutions.jts.geom.Envelope;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.geotools.factory.Hints;
import org.geotools.filter.AndImpl;
import org.geotools.filter.AttributeExpressionImpl;
import org.geotools.filter.BBoxExpression;
import org.geotools.filter.BBoxExpressionImpl;
import org.geotools.filter.FidFilterImpl;
import org.geotools.filter.Filter;
import org.geotools.filter.FilterFactory;
import org.geotools.filter.FunctionFinder;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.LiteralExpressionImpl;
import org.geotools.filter.NotImpl;
import org.geotools.filter.OrImpl;
import org.geotools.filter.capability.FunctionNameImpl;
import org.geotools.filter.expression.AddImpl;
import org.geotools.filter.expression.DivideImpl;
import org.geotools.filter.expression.MultiplyImpl;
import org.geotools.filter.expression.SubtractImpl;
import org.geotools.filter.identity.FeatureIdImpl;
import org.opengis.filter.And;
import org.opengis.filter.Id;
import org.opengis.filter.Not;
import org.opengis.filter.Or;
import org.opengis.filter.capability.FunctionName;
import org.opengis.filter.expression.Add;
import org.opengis.filter.expression.Divide;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.Multiply;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.expression.Subtract;
import org.opengis.filter.identity.FeatureId;
import org.xml.sax.helpers.NamespaceSupport;

public class FilterFactoryImpl
implements FilterFactory {
    private FunctionFinder functionFinder = new FunctionFinder(null);

    public FilterFactoryImpl() {
        this(null);
    }

    public FilterFactoryImpl(Hints hints) {
    }

    @Override
    public FeatureId featureId(String id) {
        return new FeatureIdImpl(id);
    }

    @Override
    public And and(org.opengis.filter.Filter f, org.opengis.filter.Filter g) {
        ArrayList<org.opengis.filter.Filter> list = new ArrayList<org.opengis.filter.Filter>(2);
        list.add(f);
        list.add(g);
        return new AndImpl(this, list);
    }

    public And and(List filters) {
        return new AndImpl(this, filters);
    }

    @Override
    public Or or(org.opengis.filter.Filter f, org.opengis.filter.Filter g) {
        ArrayList<org.opengis.filter.Filter> list = new ArrayList<org.opengis.filter.Filter>(2);
        list.add(f);
        list.add(g);
        return new OrImpl(this, list);
    }

    public Or or(List filters) {
        return new OrImpl(this, filters);
    }

    @Override
    public Not not(org.opengis.filter.Filter filter) {
        return new NotImpl((org.opengis.filter.FilterFactory)this, filter);
    }

    public Id id(Set id) {
        return new FidFilterImpl(id);
    }

    @Override
    public PropertyName property(String name) {
        return new AttributeExpressionImpl(name);
    }

    @Override
    public Add add(Expression expr1, Expression expr2) {
        return new AddImpl(expr1, expr2);
    }

    @Override
    public Divide divide(Expression expr1, Expression expr2) {
        return new DivideImpl(expr1, expr2);
    }

    @Override
    public Multiply multiply(Expression expr1, Expression expr2) {
        return new MultiplyImpl(expr1, expr2);
    }

    @Override
    public Subtract subtract(Expression expr1, Expression expr2) {
        return new SubtractImpl(expr1, expr2);
    }

    @Override
    public Function function(String name, Expression[] args) {
        Function function = this.functionFinder.findFunction(name, Arrays.asList(args));
        return function;
    }

    @Override
    public Literal literal(Object obj) {
        try {
            return new LiteralExpressionImpl(obj);
        }
        catch (IllegalFilterException e) {
            new IllegalArgumentException().initCause(e);
            return null;
        }
    }

    public BBoxExpression createBBoxExpression(Envelope env) throws IllegalFilterException {
        return new BBoxExpressionImpl(env);
    }

    public Map getImplementationHints() {
        return Collections.EMPTY_MAP;
    }

    @Override
    public Filter and(Filter filter1, Filter filter2) {
        return (Filter)((Object)this.and((org.opengis.filter.Filter)filter1, (org.opengis.filter.Filter)filter2));
    }

    @Override
    public Filter not(Filter filter) {
        return (Filter)((Object)this.not((org.opengis.filter.Filter)filter));
    }

    @Override
    public Filter or(Filter filter1, Filter filter2) {
        return (Filter)((Object)this.or((org.opengis.filter.Filter)filter1, (org.opengis.filter.Filter)filter2));
    }

    @Override
    public PropertyName property(String name, NamespaceSupport namespaceContext) {
        if (namespaceContext == null) {
            return this.property(name);
        }
        return new AttributeExpressionImpl(name, namespaceContext);
    }

    @Override
    public FunctionName functionName(String name, int nargs) {
        return new FunctionNameImpl(name, nargs);
    }
}

