/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.geotools.data.shapefile.FileReader;
import org.geotools.data.shapefile.FileWriter;

class ShpFilesLocker {
    final URI uri;
    final URL url;
    final FileReader reader;
    final FileWriter writer;
    boolean upgraded;

    public ShpFilesLocker(URL url, FileReader reader) {
        this.url = url;
        this.reader = reader;
        this.writer = null;
        this.uri = this.getURI(url);
    }

    URI getURI(URL url) {
        try {
            return url.toURI();
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    public ShpFilesLocker(URL url, FileWriter writer) {
        this.url = url;
        this.reader = null;
        this.writer = writer;
        this.uri = this.getURI(url);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.reader == null ? 0 : this.reader.hashCode());
        result = 31 * result + (this.url == null ? 0 : this.url.hashCode());
        result = 31 * result + (this.writer == null ? 0 : this.writer.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ShpFilesLocker other = (ShpFilesLocker)obj;
        if (this.reader == null ? other.reader != null : !this.reader.equals(other.reader)) {
            return false;
        }
        if (this.url == null ? other.url != null : (this.uri != null ? !this.uri.equals(other.uri) : !this.url.equals(other.url))) {
            return false;
        }
        return !(this.writer == null ? other.writer != null : !this.writer.equals(other.writer));
    }
}

