/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula;

import org.apache.poi.hssf.record.formula.OperandPtg;
import org.apache.poi.util.LittleEndianInput;
import org.apache.poi.util.LittleEndianOutput;

public final class MemAreaPtg
extends OperandPtg {
    public static final short sid = 38;
    private static final int SIZE = 7;
    private final int field_1_reserved;
    private final int field_2_subex_len;

    public MemAreaPtg(LittleEndianInput littleEndianInput) {
        this.field_1_reserved = littleEndianInput.readInt();
        this.field_2_subex_len = littleEndianInput.readShort();
    }

    @Override
    public void write(LittleEndianOutput littleEndianOutput) {
        littleEndianOutput.writeByte(38 + this.getPtgClass());
        littleEndianOutput.writeInt(this.field_1_reserved);
        littleEndianOutput.writeShort(this.field_2_subex_len);
    }

    @Override
    public int getSize() {
        return 7;
    }

    @Override
    public String toFormulaString() {
        return "";
    }

    @Override
    public byte getDefaultOperandClass() {
        return 32;
    }

    @Override
    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append(this.getClass().getName()).append(" [len=");
        stringBuffer.append(this.field_2_subex_len);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

