/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.overlay;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geomgraph.Label;
import com.vividsolutions.jts.geomgraph.Node;
import com.vividsolutions.jts.operation.overlay.OverlayOp;
import java.util.ArrayList;
import java.util.List;

public class PointBuilder {
    private OverlayOp op;
    private GeometryFactory geometryFactory;
    private List resultPointList = new ArrayList();

    public PointBuilder(OverlayOp overlayOp, GeometryFactory geometryFactory) {
        this.op = overlayOp;
        this.geometryFactory = geometryFactory;
    }

    public List build(int n) {
        this.extractNonCoveredResultNodes(n);
        return this.resultPointList;
    }

    private void extractNonCoveredResultNodes(int n) {
        for (Node node : this.op.getGraph().getNodes()) {
            Label label;
            if (node.isInResult() || node.isIncidentEdgeInResult() || node.getEdges().getDegree() != 0 && n != 1 || !OverlayOp.isResultOfOp(label = node.getLabel(), n)) continue;
            this.filterCoveredNodeToPoint(node);
        }
    }

    private void filterCoveredNodeToPoint(Node node) {
        Coordinate coordinate = node.getCoordinate();
        if (!this.op.isCoveredByLA(coordinate)) {
            Point point = this.geometryFactory.createPoint(coordinate);
            this.resultPointList.add(point);
        }
    }
}

