/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.noding;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.noding.NodedSegmentString;
import com.vividsolutions.jts.noding.SegmentNode;
import com.vividsolutions.jts.noding.SegmentString;
import com.vividsolutions.jts.util.Assert;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class SegmentNodeList {
    private Map nodeMap = new TreeMap();
    private NodedSegmentString edge;

    public SegmentNodeList(NodedSegmentString nodedSegmentString) {
        this.edge = nodedSegmentString;
    }

    public SegmentNode add(Coordinate coordinate, int n) {
        SegmentNode segmentNode = new SegmentNode(this.edge, coordinate, n, this.edge.getSegmentOctant(n));
        SegmentNode segmentNode2 = (SegmentNode)this.nodeMap.get(segmentNode);
        if (segmentNode2 != null) {
            Assert.isTrue(segmentNode2.coord.equals2D(coordinate), "Found equal nodes with different coordinates");
            return segmentNode2;
        }
        this.nodeMap.put(segmentNode, segmentNode);
        return segmentNode;
    }

    public Iterator iterator() {
        return this.nodeMap.values().iterator();
    }

    private void addEndpoints() {
        int n = this.edge.size() - 1;
        this.add(this.edge.getCoordinate(0), 0);
        this.add(this.edge.getCoordinate(n), n);
    }

    private void addCollapsedNodes() {
        ArrayList arrayList = new ArrayList();
        this.findCollapsesFromInsertedNodes(arrayList);
        this.findCollapsesFromExistingVertices(arrayList);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            this.add(this.edge.getCoordinate(n), n);
        }
    }

    private void findCollapsesFromExistingVertices(List list) {
        for (int i = 0; i < this.edge.size() - 2; ++i) {
            Coordinate coordinate;
            Coordinate coordinate2 = this.edge.getCoordinate(i);
            if (!coordinate2.equals2D(coordinate = this.edge.getCoordinate(i + 2))) continue;
            list.add(new Integer(i + 1));
        }
    }

    private void findCollapsesFromInsertedNodes(List list) {
        int[] nArray = new int[1];
        Iterator iterator = this.iterator();
        SegmentNode segmentNode = (SegmentNode)iterator.next();
        while (iterator.hasNext()) {
            SegmentNode segmentNode2 = (SegmentNode)iterator.next();
            boolean bl = this.findCollapseIndex(segmentNode, segmentNode2, nArray);
            if (bl) {
                list.add(new Integer(nArray[0]));
            }
            segmentNode = segmentNode2;
        }
    }

    private boolean findCollapseIndex(SegmentNode segmentNode, SegmentNode segmentNode2, int[] nArray) {
        if (!segmentNode.coord.equals2D(segmentNode2.coord)) {
            return false;
        }
        int n = segmentNode2.segmentIndex - segmentNode.segmentIndex;
        if (!segmentNode2.isInterior()) {
            --n;
        }
        if (n == 1) {
            nArray[0] = segmentNode.segmentIndex + 1;
            return true;
        }
        return false;
    }

    public void addSplitEdges(Collection collection) {
        this.addEndpoints();
        this.addCollapsedNodes();
        Iterator iterator = this.iterator();
        SegmentNode segmentNode = (SegmentNode)iterator.next();
        while (iterator.hasNext()) {
            SegmentNode segmentNode2 = (SegmentNode)iterator.next();
            SegmentString segmentString = this.createSplitEdge(segmentNode, segmentNode2);
            collection.add(segmentString);
            segmentNode = segmentNode2;
        }
    }

    SegmentString createSplitEdge(SegmentNode segmentNode, SegmentNode segmentNode2) {
        boolean bl;
        int n = segmentNode2.segmentIndex - segmentNode.segmentIndex + 2;
        Coordinate coordinate = this.edge.getCoordinate(segmentNode2.segmentIndex);
        boolean bl2 = bl = segmentNode2.isInterior() || !segmentNode2.coord.equals2D(coordinate);
        if (!bl) {
            --n;
        }
        Coordinate[] coordinateArray = new Coordinate[n];
        int n2 = 0;
        coordinateArray[n2++] = new Coordinate(segmentNode.coord);
        for (int i = segmentNode.segmentIndex + 1; i <= segmentNode2.segmentIndex; ++i) {
            coordinateArray[n2++] = this.edge.getCoordinate(i);
        }
        if (bl) {
            coordinateArray[n2] = segmentNode2.coord;
        }
        return new NodedSegmentString(coordinateArray, this.edge.getData());
    }
}

