/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.noding;

import com.vividsolutions.jts.algorithm.LineIntersector;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.noding.SegmentIntersector;
import com.vividsolutions.jts.noding.SegmentString;
import java.util.ArrayList;
import java.util.List;

public class InteriorIntersectionFinder
implements SegmentIntersector {
    private boolean findAllIntersections = false;
    private boolean isCheckEndSegmentsOnly = false;
    private LineIntersector li;
    private Coordinate interiorIntersection = null;
    private Coordinate[] intSegments = null;
    private List intersections = new ArrayList();

    public InteriorIntersectionFinder(LineIntersector lineIntersector) {
        this.li = lineIntersector;
        this.interiorIntersection = null;
    }

    public void setFindAllIntersections(boolean bl) {
        this.findAllIntersections = bl;
    }

    public boolean hasIntersection() {
        return this.interiorIntersection != null;
    }

    public Coordinate getInteriorIntersection() {
        return this.interiorIntersection;
    }

    public Coordinate[] getIntersectionSegments() {
        return this.intSegments;
    }

    @Override
    public void processIntersections(SegmentString segmentString, int n, SegmentString segmentString2, int n2) {
        if (this.hasIntersection()) {
            return;
        }
        if (segmentString == segmentString2 && n == n2) {
            return;
        }
        if (this.isCheckEndSegmentsOnly) {
            boolean bl;
            boolean bl2 = bl = this.isEndSegment(segmentString, n) || this.isEndSegment(segmentString2, n2);
            if (!bl) {
                return;
            }
        }
        Coordinate coordinate = segmentString.getCoordinates()[n];
        Coordinate coordinate2 = segmentString.getCoordinates()[n + 1];
        Coordinate coordinate3 = segmentString2.getCoordinates()[n2];
        Coordinate coordinate4 = segmentString2.getCoordinates()[n2 + 1];
        this.li.computeIntersection(coordinate, coordinate2, coordinate3, coordinate4);
        if (this.li.hasIntersection() && this.li.isInteriorIntersection()) {
            this.intSegments = new Coordinate[4];
            this.intSegments[0] = coordinate;
            this.intSegments[1] = coordinate2;
            this.intSegments[2] = coordinate3;
            this.intSegments[3] = coordinate4;
            this.interiorIntersection = this.li.getIntersection(0);
            this.intersections.add(this.interiorIntersection);
        }
    }

    private boolean isEndSegment(SegmentString segmentString, int n) {
        if (n == 0) {
            return true;
        }
        return n >= segmentString.size() - 2;
    }

    @Override
    public boolean isDone() {
        if (this.findAllIntersections) {
            return false;
        }
        return this.interiorIntersection != null;
    }
}

