/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateFilter;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.CoordinateSequenceComparator;
import com.vividsolutions.jts.geom.CoordinateSequenceFilter;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryComponentFilter;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.GeometryFilter;
import com.vividsolutions.jts.geom.Puntal;
import com.vividsolutions.jts.util.Assert;

public class Point
extends Geometry
implements Puntal {
    private static final long serialVersionUID = 4902022702746614570L;
    private CoordinateSequence coordinates;

    public Point(CoordinateSequence coordinateSequence, GeometryFactory geometryFactory) {
        super(geometryFactory);
        this.init(coordinateSequence);
    }

    private void init(CoordinateSequence coordinateSequence) {
        if (coordinateSequence == null) {
            coordinateSequence = this.getFactory().getCoordinateSequenceFactory().create(new Coordinate[0]);
        }
        Assert.isTrue(coordinateSequence.size() <= 1);
        this.coordinates = coordinateSequence;
    }

    @Override
    public Coordinate[] getCoordinates() {
        Coordinate[] coordinateArray;
        if (this.isEmpty()) {
            coordinateArray = new Coordinate[]{};
        } else {
            Coordinate[] coordinateArray2 = new Coordinate[1];
            coordinateArray = coordinateArray2;
            coordinateArray2[0] = this.getCoordinate();
        }
        return coordinateArray;
    }

    @Override
    public int getNumPoints() {
        return this.isEmpty() ? 0 : 1;
    }

    @Override
    public boolean isEmpty() {
        return this.getCoordinate() == null;
    }

    @Override
    public boolean isSimple() {
        return true;
    }

    @Override
    public int getDimension() {
        return 0;
    }

    @Override
    public int getBoundaryDimension() {
        return -1;
    }

    public double getX() {
        if (this.getCoordinate() == null) {
            throw new IllegalStateException("getX called on empty Point");
        }
        return this.getCoordinate().x;
    }

    public double getY() {
        if (this.getCoordinate() == null) {
            throw new IllegalStateException("getY called on empty Point");
        }
        return this.getCoordinate().y;
    }

    @Override
    public Coordinate getCoordinate() {
        return this.coordinates.size() != 0 ? this.coordinates.getCoordinate(0) : null;
    }

    @Override
    public String getGeometryType() {
        return "Point";
    }

    @Override
    public Geometry getBoundary() {
        return this.getFactory().createGeometryCollection(null);
    }

    @Override
    protected Envelope computeEnvelopeInternal() {
        if (this.isEmpty()) {
            return new Envelope();
        }
        Envelope envelope = new Envelope();
        envelope.expandToInclude(this.coordinates.getX(0), this.coordinates.getY(0));
        return envelope;
    }

    @Override
    public boolean equalsExact(Geometry geometry, double d) {
        if (!this.isEquivalentClass(geometry)) {
            return false;
        }
        if (this.isEmpty() && geometry.isEmpty()) {
            return true;
        }
        return this.equal(((Point)geometry).getCoordinate(), this.getCoordinate(), d);
    }

    @Override
    public void apply(CoordinateFilter coordinateFilter) {
        if (this.isEmpty()) {
            return;
        }
        coordinateFilter.filter(this.getCoordinate());
    }

    @Override
    public void apply(CoordinateSequenceFilter coordinateSequenceFilter) {
        if (this.isEmpty()) {
            return;
        }
        coordinateSequenceFilter.filter(this.coordinates, 0);
        if (coordinateSequenceFilter.isGeometryChanged()) {
            this.geometryChanged();
        }
    }

    @Override
    public void apply(GeometryFilter geometryFilter) {
        geometryFilter.filter(this);
    }

    @Override
    public void apply(GeometryComponentFilter geometryComponentFilter) {
        geometryComponentFilter.filter(this);
    }

    @Override
    public Object clone() {
        Point point = (Point)super.clone();
        point.coordinates = (CoordinateSequence)this.coordinates.clone();
        return point;
    }

    @Override
    public Geometry reverse() {
        return (Geometry)this.clone();
    }

    @Override
    public void normalize() {
    }

    @Override
    protected int compareToSameClass(Object object) {
        Point point = (Point)object;
        return this.getCoordinate().compareTo(point.getCoordinate());
    }

    @Override
    protected int compareToSameClass(Object object, CoordinateSequenceComparator coordinateSequenceComparator) {
        Point point = (Point)object;
        return coordinateSequenceComparator.compare(this.coordinates, point.coordinates);
    }

    public CoordinateSequence getCoordinateSequence() {
        return this.coordinates;
    }
}

