/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.core.io;

import java.io.File;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.AbstractReader;
import org.openstreetmap.josm.io.OsmServerReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.plugins.opendata.core.OdConstants;
import org.openstreetmap.josm.plugins.opendata.core.datasets.AbstractDataSetHandler;
import org.openstreetmap.josm.plugins.opendata.core.io.archive.ZipReader;
import org.openstreetmap.josm.plugins.opendata.core.io.geographic.KmlReader;
import org.openstreetmap.josm.plugins.opendata.core.io.geographic.KmzReader;
import org.openstreetmap.josm.plugins.opendata.core.io.geographic.MifReader;
import org.openstreetmap.josm.plugins.opendata.core.io.geographic.ShpReader;
import org.openstreetmap.josm.plugins.opendata.core.io.geographic.TabReader;
import org.openstreetmap.josm.plugins.opendata.core.io.tabular.CsvReader;
import org.openstreetmap.josm.plugins.opendata.core.io.tabular.OdsReader;
import org.openstreetmap.josm.plugins.opendata.core.io.tabular.XlsReader;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;

public class NetworkReader
extends OsmServerReader
implements OdConstants {
    private final String url;
    private final AbstractDataSetHandler handler;
    private Class<? extends AbstractReader> readerClass;
    private File file;
    private String filename;

    public NetworkReader(String url, AbstractDataSetHandler handler) {
        CheckParameterUtil.ensureParameterNotNull((Object)url, (String)"url");
        this.url = url;
        this.handler = handler;
        this.readerClass = null;
    }

    public final File getReadFile() {
        return this.file;
    }

    public final String getReadFileName() {
        return this.filename;
    }

    private Class<? extends AbstractReader> findReaderByAttachment() {
        Matcher m;
        String cdisp = this.activeConnection.getHeaderField("Content-disposition");
        if (cdisp != null && (m = Pattern.compile("attachment;.?filename=(.*)").matcher(cdisp)).matches()) {
            this.filename = m.group(1);
            return this.findReaderByExtension(this.filename.toLowerCase());
        }
        return null;
    }

    private Class<? extends AbstractReader> findReaderByContentType() {
        String contentType = this.activeConnection.getContentType();
        if (contentType.startsWith("application/zip")) {
            return ZipReader.class;
        }
        if (contentType.startsWith("application/vnd.ms-excel")) {
            return XlsReader.class;
        }
        if (!contentType.startsWith("application/octet-stream")) {
            if (contentType.startsWith("text/csv")) {
                return CsvReader.class;
            }
            if (contentType.startsWith("text/plain")) {
                return CsvReader.class;
            }
            if (!contentType.startsWith("tdyn/html")) {
                System.err.println("Unsupported content type: " + contentType);
            }
        }
        return null;
    }

    private Class<? extends AbstractReader> findReaderByExtension(String filename) {
        if ((filename = filename.replace("\"", "")).endsWith(".xls")) {
            return XlsReader.class;
        }
        if (filename.endsWith(".csv")) {
            return CsvReader.class;
        }
        if (filename.endsWith(".ods")) {
            return OdsReader.class;
        }
        if (filename.endsWith(".kml")) {
            return KmlReader.class;
        }
        if (filename.endsWith(".kmz")) {
            return KmzReader.class;
        }
        if (filename.endsWith(".mif")) {
            return MifReader.class;
        }
        if (filename.endsWith(".shp")) {
            return ShpReader.class;
        }
        if (filename.endsWith(".tab")) {
            return TabReader.class;
        }
        if (filename.endsWith(".zip")) {
            return ZipReader.class;
        }
        return null;
    }

    public DataSet parseOsm(ProgressMonitor progressMonitor) throws OsmTransferException {
        ProgressMonitor instance;
        InputStream in;
        block77: {
            DataSet zipReader22222222;
            block78: {
                block75: {
                    DataSet zipReader22222222;
                    block76: {
                        block73: {
                            DataSet zipReader22222222;
                            block74: {
                                block71: {
                                    DataSet zipReader22222222;
                                    block72: {
                                        block69: {
                                            DataSet zipReader22222222;
                                            block70: {
                                                block67: {
                                                    DataSet zipReader22222222;
                                                    block68: {
                                                        block65: {
                                                            DataSet zipReader22222222;
                                                            block66: {
                                                                block63: {
                                                                    DataSet zipReader22222222;
                                                                    block64: {
                                                                        block61: {
                                                                            DataSet dataSet;
                                                                            block62: {
                                                                                block59: {
                                                                                    DataSet dataSet2;
                                                                                    block60: {
                                                                                        in = null;
                                                                                        instance = null;
                                                                                        in = this.getInputStreamRaw(this.url, progressMonitor);
                                                                                        if (in != null) break block59;
                                                                                        dataSet2 = null;
                                                                                        if (instance == null) break block60;
                                                                                        instance.finishTask();
                                                                                    }
                                                                                    progressMonitor.finishTask();
                                                                                    try {
                                                                                        this.activeConnection = null;
                                                                                        if (in != null) {
                                                                                            in.close();
                                                                                        }
                                                                                    }
                                                                                    catch (Exception e) {
                                                                                        // empty catch block
                                                                                    }
                                                                                    return dataSet2;
                                                                                }
                                                                                progressMonitor.subTask(I18n.tr((String)"Downloading data...", (Object[])new Object[0]));
                                                                                if (this.readerClass == null) {
                                                                                    this.readerClass = this.findReaderByAttachment();
                                                                                }
                                                                                if (this.readerClass == null) {
                                                                                    this.readerClass = this.findReaderByContentType();
                                                                                }
                                                                                if (this.readerClass == null) {
                                                                                    this.readerClass = this.findReaderByExtension(this.url.toLowerCase());
                                                                                }
                                                                                if (this.readerClass == null) {
                                                                                    throw new OsmTransferException("Cannot find appropriate reader !");
                                                                                }
                                                                                if (this.findReaderByExtension(this.url.toLowerCase()) != null) {
                                                                                    this.filename = this.url.substring(this.url.lastIndexOf(47) + 1);
                                                                                }
                                                                                instance = progressMonitor.createSubTaskMonitor(-1, false);
                                                                                if (!this.readerClass.equals(ZipReader.class)) break block61;
                                                                                ZipReader zipReader22222222 = new ZipReader(in, this.handler);
                                                                                DataSet ds = zipReader22222222.parseDoc(instance);
                                                                                this.file = zipReader22222222.getReadFile();
                                                                                dataSet = ds;
                                                                                if (instance == null) break block62;
                                                                                instance.finishTask();
                                                                            }
                                                                            progressMonitor.finishTask();
                                                                            try {
                                                                                this.activeConnection = null;
                                                                                if (in != null) {
                                                                                    in.close();
                                                                                }
                                                                            }
                                                                            catch (Exception e) {
                                                                                // empty catch block
                                                                            }
                                                                            return dataSet;
                                                                        }
                                                                        if (!this.readerClass.equals(KmlReader.class)) break block63;
                                                                        zipReader22222222 = KmlReader.parseDataSet(in, instance);
                                                                        if (instance == null) break block64;
                                                                        instance.finishTask();
                                                                    }
                                                                    progressMonitor.finishTask();
                                                                    try {
                                                                        this.activeConnection = null;
                                                                        if (in != null) {
                                                                            in.close();
                                                                        }
                                                                    }
                                                                    catch (Exception e) {
                                                                        // empty catch block
                                                                    }
                                                                    return zipReader22222222;
                                                                }
                                                                if (!this.readerClass.equals(KmzReader.class)) break block65;
                                                                zipReader22222222 = KmzReader.parseDataSet(in, instance);
                                                                if (instance == null) break block66;
                                                                instance.finishTask();
                                                            }
                                                            progressMonitor.finishTask();
                                                            try {
                                                                this.activeConnection = null;
                                                                if (in != null) {
                                                                    in.close();
                                                                }
                                                            }
                                                            catch (Exception e) {
                                                                // empty catch block
                                                            }
                                                            return zipReader22222222;
                                                        }
                                                        if (!this.readerClass.equals(MifReader.class)) break block67;
                                                        zipReader22222222 = MifReader.parseDataSet(in, null, this.handler, instance);
                                                        if (instance == null) break block68;
                                                        instance.finishTask();
                                                    }
                                                    progressMonitor.finishTask();
                                                    try {
                                                        this.activeConnection = null;
                                                        if (in != null) {
                                                            in.close();
                                                        }
                                                    }
                                                    catch (Exception e) {
                                                        // empty catch block
                                                    }
                                                    return zipReader22222222;
                                                }
                                                if (!this.readerClass.equals(ShpReader.class)) break block69;
                                                zipReader22222222 = ShpReader.parseDataSet(in, null, this.handler, instance);
                                                if (instance == null) break block70;
                                                instance.finishTask();
                                            }
                                            progressMonitor.finishTask();
                                            try {
                                                this.activeConnection = null;
                                                if (in != null) {
                                                    in.close();
                                                }
                                            }
                                            catch (Exception e) {
                                                // empty catch block
                                            }
                                            return zipReader22222222;
                                        }
                                        if (!this.readerClass.equals(TabReader.class)) break block71;
                                        zipReader22222222 = TabReader.parseDataSet(in, null, this.handler, instance);
                                        if (instance == null) break block72;
                                        instance.finishTask();
                                    }
                                    progressMonitor.finishTask();
                                    try {
                                        this.activeConnection = null;
                                        if (in != null) {
                                            in.close();
                                        }
                                    }
                                    catch (Exception e) {
                                        // empty catch block
                                    }
                                    return zipReader22222222;
                                }
                                if (!this.readerClass.equals(CsvReader.class)) break block73;
                                zipReader22222222 = CsvReader.parseDataSet(in, this.handler, instance);
                                if (instance == null) break block74;
                                instance.finishTask();
                            }
                            progressMonitor.finishTask();
                            try {
                                this.activeConnection = null;
                                if (in != null) {
                                    in.close();
                                }
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                            return zipReader22222222;
                        }
                        if (!this.readerClass.equals(OdsReader.class)) break block75;
                        zipReader22222222 = OdsReader.parseDataSet(in, this.handler, instance);
                        if (instance == null) break block76;
                        instance.finishTask();
                    }
                    progressMonitor.finishTask();
                    try {
                        this.activeConnection = null;
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    return zipReader22222222;
                }
                if (!this.readerClass.equals(XlsReader.class)) break block77;
                zipReader22222222 = XlsReader.parseDataSet(in, this.handler, instance);
                if (instance == null) break block78;
                instance.finishTask();
            }
            progressMonitor.finishTask();
            try {
                this.activeConnection = null;
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            return zipReader22222222;
        }
        try {
            try {
                throw new IllegalArgumentException("Unsupported reader class: " + this.readerClass.getName());
            }
            catch (OsmTransferException e) {
                throw e;
            }
            catch (Exception e) {
                if (this.cancel) {
                    DataSet dataSet = null;
                    return dataSet;
                }
                throw new OsmTransferException((Throwable)e);
            }
        }
        finally {
            if (instance != null) {
                instance.finishTask();
            }
            progressMonitor.finishTask();
            try {
                this.activeConnection = null;
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e) {}
        }
    }
}

