/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.simple;

import com.vividsolutions.jts.geom.Geometry;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.geotools.feature.AttributeTypeBuilder;
import org.geotools.feature.NameImpl;
import org.geotools.feature.simple.SimpleSchema;
import org.geotools.feature.type.BasicFeatureTypes;
import org.geotools.feature.type.FeatureTypeFactoryImpl;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.FeatureTypeFactory;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.GeometryType;
import org.opengis.feature.type.Name;
import org.opengis.feature.type.Schema;
import org.opengis.filter.Filter;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.util.InternationalString;

public class SimpleFeatureTypeBuilder {
    protected FeatureTypeFactory factory;
    protected Map bindings;
    protected String local;
    protected String uri;
    protected InternationalString description;
    protected List<AttributeDescriptor> attributes;
    protected List<Filter> restrictions;
    protected String defaultGeometry;
    protected CoordinateReferenceSystem crs;
    protected boolean isAbstract = false;
    protected SimpleFeatureType superType;
    protected AttributeTypeBuilder attributeBuilder;

    public SimpleFeatureTypeBuilder() {
        this(new FeatureTypeFactoryImpl());
    }

    public SimpleFeatureTypeBuilder(FeatureTypeFactory factory) {
        this.factory = factory;
        this.attributeBuilder = new AttributeTypeBuilder();
        this.setBindings(new SimpleSchema());
        this.reset();
    }

    public void init(SimpleFeatureType type) {
        this.init();
        if (type == null) {
            return;
        }
        this.uri = type.getName().getNamespaceURI();
        this.local = type.getName().getLocalPart();
        this.description = type.getDescription();
        this.restrictions = null;
        this.restrictions().addAll(type.getRestrictions());
        this.attributes = null;
        this.attributes().addAll(type.getAttributeDescriptors());
        this.isAbstract = type.isAbstract();
        this.superType = (SimpleFeatureType)type.getSuper();
    }

    protected void init() {
        this.attributes = null;
    }

    protected void reset() {
        this.uri = "http://www.opengis.net/gml";
        this.local = null;
        this.description = null;
        this.restrictions = null;
        this.attributes = null;
        this.crs = null;
        this.isAbstract = false;
        this.superType = BasicFeatureTypes.FEATURE;
    }

    public void setNamespaceURI(String namespaceURI) {
        this.uri = namespaceURI;
    }

    public void setNamespaceURI(URI namespaceURI) {
        if (namespaceURI != null) {
            this.setNamespaceURI(namespaceURI.toString());
        } else {
            this.setNamespaceURI((String)null);
        }
    }

    public void setName(String name) {
        this.local = name;
    }

    public void setName(Name name) {
        this.setName(name.getLocalPart());
        this.setNamespaceURI(name.getNamespaceURI());
    }

    public void setDefaultGeometry(String defaultGeometryName) {
        this.defaultGeometry = defaultGeometryName;
    }

    public void setAbstract(boolean isAbstract) {
        this.isAbstract = isAbstract;
    }

    public void setSuperType(SimpleFeatureType superType) {
        this.superType = superType;
    }

    public void addBinding(AttributeType type) {
        this.bindings().put(type.getBinding(), type);
    }

    public void addBindings(Schema schema) {
        for (AttributeType type : schema.values()) {
            this.addBinding(type);
        }
    }

    public void setBindings(Schema schema) {
        this.bindings().clear();
        this.addBindings(schema);
    }

    public SimpleFeatureTypeBuilder minOccurs(int minOccurs) {
        this.attributeBuilder.setMinOccurs(minOccurs);
        return this;
    }

    public SimpleFeatureTypeBuilder maxOccurs(int maxOccurs) {
        this.attributeBuilder.setMaxOccurs(maxOccurs);
        return this;
    }

    public SimpleFeatureTypeBuilder nillable(boolean isNillable) {
        this.attributeBuilder.setNillable(isNillable);
        return this;
    }

    public SimpleFeatureTypeBuilder defaultValue(Object defaultValue) {
        this.attributeBuilder.setDefaultValue(defaultValue);
        return this;
    }

    public SimpleFeatureTypeBuilder crs(CoordinateReferenceSystem crs) {
        this.attributeBuilder.setCRS(crs);
        return this;
    }

    public SimpleFeatureTypeBuilder descriptor(AttributeDescriptor descriptor) {
        this.minOccurs(descriptor.getMinOccurs());
        this.maxOccurs(descriptor.getMaxOccurs());
        this.nillable(descriptor.isNillable());
        this.defaultValue(descriptor.getDefaultValue());
        if (descriptor instanceof GeometryDescriptor) {
            this.crs(((GeometryDescriptor)descriptor).getCoordinateReferenceSystem());
        }
        return this;
    }

    public void add(String name, Class binding) {
        AttributeDescriptor descriptor = null;
        this.attributeBuilder.setBinding(binding);
        this.attributeBuilder.setName(name);
        if (this.defaultGeometry != null && this.defaultGeometry.equals(name) || Geometry.class.isAssignableFrom(binding)) {
            if (!this.attributeBuilder.isCRSSet()) {
                this.attributeBuilder.setCRS(this.crs);
            }
            GeometryType type = this.attributeBuilder.buildGeometryType();
            descriptor = this.attributeBuilder.buildDescriptor(name, type);
        } else {
            AttributeType type = this.attributeBuilder.buildType();
            descriptor = this.attributeBuilder.buildDescriptor(name, type);
        }
        this.attributes().add(descriptor);
    }

    public void add(AttributeDescriptor descriptor) {
        this.attributes().add(descriptor);
    }

    public void addAll(List<AttributeDescriptor> descriptors) {
        if (descriptors != null) {
            for (AttributeDescriptor ad : descriptors) {
                this.add(ad);
            }
        }
    }

    public void addAll(AttributeDescriptor[] descriptors) {
        if (descriptors != null) {
            for (AttributeDescriptor ad : descriptors) {
                this.add(ad);
            }
        }
    }

    public SimpleFeatureType buildFeatureType() {
        GeometryDescriptor defGeom = null;
        if (this.defaultGeometry != null) {
            List<AttributeDescriptor> atts = this.attributes();
            for (int i = 0; i < atts.size(); ++i) {
                AttributeDescriptor att = atts.get(i);
                if (!this.defaultGeometry.equals(att.getName().getLocalPart())) continue;
                if (!(att instanceof GeometryDescriptor)) {
                    this.attributeBuilder.init(att);
                    this.attributeBuilder.setCRS(this.crs);
                    GeometryType type = this.attributeBuilder.buildGeometryType();
                    att = this.attributeBuilder.buildDescriptor(att.getName(), type);
                    atts.set(i, att);
                }
                defGeom = (GeometryDescriptor)att;
                break;
            }
            if (defGeom == null) {
                String msg = "'" + this.defaultGeometry + " specified as default" + " but could find no such attribute.";
                throw new IllegalArgumentException(msg);
            }
        }
        if (defGeom == null) {
            for (AttributeDescriptor att : this.attributes()) {
                if (!(att instanceof GeometryDescriptor)) continue;
                defGeom = (GeometryDescriptor)att;
                break;
            }
        }
        SimpleFeatureType built = this.factory.createSimpleFeatureType(this.name(), this.attributes(), defGeom, this.isAbstract, this.restrictions(), this.superType, this.description);
        this.init();
        return built;
    }

    protected List newList() {
        return new ArrayList();
    }

    protected Map newMap() {
        return new HashMap();
    }

    protected Name name() {
        if (this.local == null) {
            return null;
        }
        return new NameImpl(this.uri, this.local);
    }

    protected List<AttributeDescriptor> attributes() {
        if (this.attributes == null) {
            this.attributes = this.newList();
        }
        return this.attributes;
    }

    protected List<Filter> restrictions() {
        if (this.restrictions == null) {
            this.restrictions = this.newList();
        }
        return this.restrictions;
    }

    protected Map bindings() {
        if (this.bindings == null) {
            this.bindings = this.newMap();
        }
        return this.bindings;
    }

    public static SimpleFeatureType retype(SimpleFeatureType original, String[] types) {
        SimpleFeatureTypeBuilder b = new SimpleFeatureTypeBuilder();
        b.init(original);
        b.attributes().clear();
        for (int i = 0; i < types.length; ++i) {
            b.add(original.getDescriptor(types[i]));
        }
        return b.buildFeatureType();
    }
}

