/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.noding;

import com.vividsolutions.jts.index.SpatialIndex;
import com.vividsolutions.jts.index.chain.MonotoneChain;
import com.vividsolutions.jts.index.chain.MonotoneChainBuilder;
import com.vividsolutions.jts.index.chain.MonotoneChainOverlapAction;
import com.vividsolutions.jts.index.strtree.STRtree;
import com.vividsolutions.jts.noding.SegmentIntersector;
import com.vividsolutions.jts.noding.SegmentSetMutualIntersector;
import com.vividsolutions.jts.noding.SegmentString;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class MCIndexSegmentSetMutualIntersector
extends SegmentSetMutualIntersector {
    private List monoChains = new ArrayList();
    private SpatialIndex index = new STRtree();
    private int indexCounter = 0;
    private int processCounter = 0;

    @Override
    public void setBaseSegments(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.addToIndex((SegmentString)iterator.next());
        }
    }

    private void addToIndex(SegmentString segmentString) {
        List list = MonotoneChainBuilder.getChains(segmentString.getCoordinates(), segmentString);
        for (MonotoneChain monotoneChain : list) {
            monotoneChain.setId(this.indexCounter++);
            this.index.insert(monotoneChain.getEnvelope(), monotoneChain);
        }
    }

    @Override
    public void process(Collection collection) {
        this.processCounter = this.indexCounter + 1;
        this.monoChains.clear();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.addToMonoChains((SegmentString)iterator.next());
        }
        this.intersectChains();
    }

    private void intersectChains() {
        SegmentOverlapAction segmentOverlapAction = new SegmentOverlapAction(this.segInt);
        for (MonotoneChain monotoneChain : this.monoChains) {
            List list = this.index.query(monotoneChain.getEnvelope());
            for (MonotoneChain monotoneChain2 : list) {
                monotoneChain.computeOverlaps(monotoneChain2, segmentOverlapAction);
                if (!this.segInt.isDone()) continue;
                return;
            }
        }
    }

    private void addToMonoChains(SegmentString segmentString) {
        List list = MonotoneChainBuilder.getChains(segmentString.getCoordinates(), segmentString);
        for (MonotoneChain monotoneChain : list) {
            monotoneChain.setId(this.processCounter++);
            this.monoChains.add(monotoneChain);
        }
    }

    public class SegmentOverlapAction
    extends MonotoneChainOverlapAction {
        private SegmentIntersector si = null;

        public SegmentOverlapAction(SegmentIntersector segmentIntersector) {
            this.si = segmentIntersector;
        }

        @Override
        public void overlap(MonotoneChain monotoneChain, int n, MonotoneChain monotoneChain2, int n2) {
            SegmentString segmentString = (SegmentString)monotoneChain.getContext();
            SegmentString segmentString2 = (SegmentString)monotoneChain2.getContext();
            this.si.processIntersections(segmentString, n, segmentString2, n2);
        }
    }
}

