/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geomgraph;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.IntersectionMatrix;
import com.vividsolutions.jts.geomgraph.DirectedEdge;
import com.vividsolutions.jts.geomgraph.EdgeEnd;
import com.vividsolutions.jts.geomgraph.EdgeEndStar;
import com.vividsolutions.jts.geomgraph.GraphComponent;
import com.vividsolutions.jts.geomgraph.Label;

public class Node
extends GraphComponent {
    protected Coordinate coord;
    protected EdgeEndStar edges;

    public Node(Coordinate coordinate, EdgeEndStar edgeEndStar) {
        this.coord = coordinate;
        this.edges = edgeEndStar;
        this.label = new Label(0, -1);
    }

    @Override
    public Coordinate getCoordinate() {
        return this.coord;
    }

    public EdgeEndStar getEdges() {
        return this.edges;
    }

    public boolean isIncidentEdgeInResult() {
        for (DirectedEdge directedEdge : this.getEdges().getEdges()) {
            if (!directedEdge.getEdge().isInResult()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isIsolated() {
        return this.label.getGeometryCount() == 1;
    }

    @Override
    protected void computeIM(IntersectionMatrix intersectionMatrix) {
    }

    public void add(EdgeEnd edgeEnd) {
        this.edges.insert(edgeEnd);
        edgeEnd.setNode(this);
    }

    public void setLabel(int n, int n2) {
        if (this.label == null) {
            this.label = new Label(n, n2);
        } else {
            this.label.setLocation(n, n2);
        }
    }

    public void setLabelBoundary(int n) {
        int n2;
        int n3 = -1;
        if (this.label != null) {
            n3 = this.label.getLocation(n);
        }
        switch (n3) {
            case 1: {
                n2 = 0;
                break;
            }
            case 0: {
                n2 = 1;
                break;
            }
            default: {
                n2 = 1;
            }
        }
        this.label.setLocation(n, n2);
    }
}

