/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom;

import com.vividsolutions.jts.geom.Dimension;

public class IntersectionMatrix
implements Cloneable {
    private int[][] matrix = new int[3][3];

    public IntersectionMatrix() {
        this.setAll(-1);
    }

    public static boolean matches(int n, char c) {
        if (c == '*') {
            return true;
        }
        if (c == 'T' && (n >= 0 || n == -2)) {
            return true;
        }
        if (c == 'F' && n == -1) {
            return true;
        }
        if (c == '0' && n == 0) {
            return true;
        }
        if (c == '1' && n == 1) {
            return true;
        }
        return c == '2' && n == 2;
    }

    public void set(int n, int n2, int n3) {
        this.matrix[n][n2] = n3;
    }

    public void setAtLeast(int n, int n2, int n3) {
        if (this.matrix[n][n2] < n3) {
            this.matrix[n][n2] = n3;
        }
    }

    public void setAtLeastIfValid(int n, int n2, int n3) {
        if (n >= 0 && n2 >= 0) {
            this.setAtLeast(n, n2, n3);
        }
    }

    public void setAtLeast(String string) {
        for (int i = 0; i < string.length(); ++i) {
            int n = i / 3;
            int n2 = i % 3;
            this.setAtLeast(n, n2, Dimension.toDimensionValue(string.charAt(i)));
        }
    }

    public void setAll(int n) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.matrix[i][j] = n;
            }
        }
    }

    public boolean isDisjoint() {
        return this.matrix[0][0] == -1 && this.matrix[0][1] == -1 && this.matrix[1][0] == -1 && this.matrix[1][1] == -1;
    }

    public boolean isIntersects() {
        return !this.isDisjoint();
    }

    public boolean isTouches(int n, int n2) {
        if (n > n2) {
            return this.isTouches(n2, n);
        }
        if (n == 2 && n2 == 2 || n == 1 && n2 == 1 || n == 1 && n2 == 2 || n == 0 && n2 == 2 || n == 0 && n2 == 1) {
            return this.matrix[0][0] == -1 && (IntersectionMatrix.matches(this.matrix[0][1], 'T') || IntersectionMatrix.matches(this.matrix[1][0], 'T') || IntersectionMatrix.matches(this.matrix[1][1], 'T'));
        }
        return false;
    }

    public boolean isCrosses(int n, int n2) {
        if (n == 0 && n2 == 1 || n == 0 && n2 == 2 || n == 1 && n2 == 2) {
            return IntersectionMatrix.matches(this.matrix[0][0], 'T') && IntersectionMatrix.matches(this.matrix[0][2], 'T');
        }
        if (n == 1 && n2 == 0 || n == 2 && n2 == 0 || n == 2 && n2 == 1) {
            return IntersectionMatrix.matches(this.matrix[0][0], 'T') && IntersectionMatrix.matches(this.matrix[2][0], 'T');
        }
        if (n == 1 && n2 == 1) {
            return this.matrix[0][0] == 0;
        }
        return false;
    }

    public boolean isContains() {
        return IntersectionMatrix.matches(this.matrix[0][0], 'T') && this.matrix[2][0] == -1 && this.matrix[2][1] == -1;
    }

    public boolean isCovers() {
        boolean bl = IntersectionMatrix.matches(this.matrix[0][0], 'T') || IntersectionMatrix.matches(this.matrix[0][1], 'T') || IntersectionMatrix.matches(this.matrix[1][0], 'T') || IntersectionMatrix.matches(this.matrix[1][1], 'T');
        return bl && this.matrix[2][0] == -1 && this.matrix[2][1] == -1;
    }

    public boolean isEquals(int n, int n2) {
        if (n != n2) {
            return false;
        }
        return IntersectionMatrix.matches(this.matrix[0][0], 'T') && this.matrix[2][0] == -1 && this.matrix[0][2] == -1 && this.matrix[2][1] == -1 && this.matrix[1][2] == -1;
    }

    public boolean isOverlaps(int n, int n2) {
        if (n == 0 && n2 == 0 || n == 2 && n2 == 2) {
            return IntersectionMatrix.matches(this.matrix[0][0], 'T') && IntersectionMatrix.matches(this.matrix[0][2], 'T') && IntersectionMatrix.matches(this.matrix[2][0], 'T');
        }
        if (n == 1 && n2 == 1) {
            return this.matrix[0][0] == 1 && IntersectionMatrix.matches(this.matrix[0][2], 'T') && IntersectionMatrix.matches(this.matrix[2][0], 'T');
        }
        return false;
    }

    public boolean matches(String string) {
        if (string.length() != 9) {
            throw new IllegalArgumentException("Should be length 9: " + string);
        }
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                if (IntersectionMatrix.matches(this.matrix[i][j], string.charAt(3 * i + j))) continue;
                return false;
            }
        }
        return true;
    }

    public IntersectionMatrix transpose() {
        int n = this.matrix[1][0];
        this.matrix[1][0] = this.matrix[0][1];
        this.matrix[0][1] = n;
        n = this.matrix[2][0];
        this.matrix[2][0] = this.matrix[0][2];
        this.matrix[0][2] = n;
        n = this.matrix[2][1];
        this.matrix[2][1] = this.matrix[1][2];
        this.matrix[1][2] = n;
        return this;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("123456789");
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                stringBuffer.setCharAt(3 * i + j, Dimension.toDimensionSymbol(this.matrix[i][j]));
            }
        }
        return stringBuffer.toString();
    }
}

