/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.algorithm;

import com.vividsolutions.jts.algorithm.RobustDeterminant;
import com.vividsolutions.jts.geom.Coordinate;

public class RayCrossingCounter {
    private Coordinate p;
    private int crossingCount = 0;
    private boolean isPointOnSegment = false;

    public static int locatePointInRing(Coordinate coordinate, Coordinate[] coordinateArray) {
        RayCrossingCounter rayCrossingCounter = new RayCrossingCounter(coordinate);
        for (int i = 1; i < coordinateArray.length; ++i) {
            Coordinate coordinate2 = coordinateArray[i];
            Coordinate coordinate3 = coordinateArray[i - 1];
            rayCrossingCounter.countSegment(coordinate2, coordinate3);
            if (!rayCrossingCounter.isOnSegment()) continue;
            return rayCrossingCounter.getLocation();
        }
        return rayCrossingCounter.getLocation();
    }

    public RayCrossingCounter(Coordinate coordinate) {
        this.p = coordinate;
    }

    public void countSegment(Coordinate coordinate, Coordinate coordinate2) {
        if (coordinate.x < this.p.x && coordinate2.x < this.p.x) {
            return;
        }
        if (this.p.x == coordinate2.x && this.p.y == coordinate2.y) {
            this.isPointOnSegment = true;
            return;
        }
        if (coordinate.y == this.p.y && coordinate2.y == this.p.y) {
            double d = coordinate.x;
            double d2 = coordinate2.x;
            if (d > d2) {
                d = coordinate2.x;
                d2 = coordinate.x;
            }
            if (this.p.x >= d && this.p.x <= d2) {
                this.isPointOnSegment = true;
            }
            return;
        }
        if (coordinate.y > this.p.y && coordinate2.y <= this.p.y || coordinate2.y > this.p.y && coordinate.y <= this.p.y) {
            double d = coordinate.x - this.p.x;
            double d3 = coordinate.y - this.p.y;
            double d4 = coordinate2.x - this.p.x;
            double d5 = coordinate2.y - this.p.y;
            double d6 = RobustDeterminant.signOfDet2x2(d, d3, d4, d5);
            if (d6 == 0.0) {
                this.isPointOnSegment = true;
                return;
            }
            if (d5 < d3) {
                d6 = -d6;
            }
            if (d6 > 0.0) {
                ++this.crossingCount;
            }
        }
    }

    public boolean isOnSegment() {
        return this.isPointOnSegment;
    }

    public int getLocation() {
        if (this.isPointOnSegment) {
            return 1;
        }
        if (this.crossingCount % 2 == 1) {
            return 0;
        }
        return 2;
    }
}

