/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.modules.fr.paris.datasets.urbanisme;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.plugins.opendata.core.datasets.fr.FrenchShpHandler;
import org.openstreetmap.josm.plugins.opendata.core.io.geographic.ShpHandler;
import org.openstreetmap.josm.plugins.opendata.modules.fr.paris.datasets.ParisDataSetHandler;
import org.openstreetmap.josm.tools.Geometry;

public class EclairagePublicHandler
extends ParisDataSetHandler {
    private final InternalShpHandler shpHandler = new InternalShpHandler();

    public EclairagePublicHandler() {
        super(94);
        this.setName("\u00c9clairage public");
        this.setShpHandler((ShpHandler)this.shpHandler);
    }

    public boolean acceptsFilename(String filename) {
        return this.acceptsShpFilename(filename, new String[]{"eclairage_public"}) || this.acceptsZipFilename(filename, new String[]{"eclairage_public"});
    }

    @Override
    protected String getDirectLink() {
        return "http://opendata.paris.fr/opendata/hn/eclairage_public.zip";
    }

    public void updateDataSet(DataSet ds) {
        this.shpHandler.nodes.clear();
    }

    private class InternalShpHandler
    extends FrenchShpHandler {
        private final Map<String, Node> nodes = new HashMap<String, Node>();

        public InternalShpHandler() {
            this.setDbfCharset(Charset.forName("Cp850"));
        }

        private Node getNode(EastNorth en, String key) {
            Node n = this.nodes.get(key);
            return n;
        }

        private Node createOrGetNode(DataSet ds, EastNorth en) {
            String key = en.getX() + "/" + en.getY();
            Node n = this.getNode(en, key);
            if (n == null) {
                n = new Node(en);
                this.nodes.put(key, n);
                ds.addPrimitive((OsmPrimitive)n);
            }
            return n;
        }

        public void notifyFeatureParsed(Object feature, DataSet result, Set<OsmPrimitive> featurePrimitives) {
            OsmPrimitive dataPrimitive = null;
            Way closedWay = null;
            ArrayList<Way> ways = new ArrayList<Way>();
            ArrayList<Node> nodes = new ArrayList<Node>();
            for (OsmPrimitive p : featurePrimitives) {
                if (p.hasKeys()) {
                    dataPrimitive = p;
                }
                if (p instanceof Way) {
                    Way w = (Way)p;
                    ways.add(w);
                    if (!w.isClosed()) continue;
                    closedWay = w;
                    continue;
                }
                if (!(p instanceof Node)) continue;
                nodes.add((Node)p);
            }
            if (dataPrimitive == null) {
                System.err.println("Found no primitive with tags");
            } else if (closedWay == null) {
                dataPrimitive.put("FIXME", "This way is not closed and has not been recognized as highway=street_lamp.");
            } else {
                Node centroid = this.createOrGetNode(result, Geometry.getCentroid((List)closedWay.getNodes()));
                if (!centroid.hasKeys()) {
                    centroid.setKeys(dataPrimitive.getKeys());
                    centroid.put("highway", "street_lamp");
                    EclairagePublicHandler.this.replace((IPrimitive)centroid, "Libelle", "lamp_model:fr");
                } else if (!(centroid.get("lamp_model:fr") == null || dataPrimitive.get("Libelle") != null && dataPrimitive.get("Libelle").equals(centroid.get("lamp_model:fr")))) {
                    System.err.println("Found 2 street lamps at the same position with different types: '" + centroid.get("lamp_model:fr") + "' and '" + dataPrimitive.get("Libelle") + "'.");
                }
                for (Way w : ways) {
                    w.setNodes(null);
                    result.removePrimitive((PrimitiveId)w);
                }
                for (Node n : nodes) {
                    result.removePrimitive((PrimitiveId)n);
                }
                if (centroid.get("lamp_model:fr") != null) {
                    if (centroid.get("lamp_model:fr").contains("mural") && !centroid.get("lamp_model:fr").contains("au sol")) {
                        centroid.put("lamp_mount", "wall mounted");
                    } else if (centroid.get("lamp_model:fr").contains("au sol") && !centroid.get("lamp_model:fr").contains("mural")) {
                        centroid.put("lamp_mount", "ground");
                    } else {
                        centroid.put("lamp_mount", "pole");
                    }
                    centroid.remove("Info");
                }
            }
        }
    }
}

