/*
 * Decompiled with CFR 0.152.
 */
package smed.tabs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.tools.I18n;
import smed.menu.SmedMenuBar;
import smed.plug.ifc.SmedPluggable;
import smed.tabs.SmedTabbedPane;

public class SmedTabAction
extends JosmAction {
    private static final long serialVersionUID = 1L;
    private SmedTabbedPane smedTabs = new SmedTabbedPane();
    private SmedMenuBar smedMenu = new SmedMenuBar();
    private JFrame frame = null;
    private boolean isOpen = false;
    private JMenuItem osmItem = null;
    public static JTextField smedStatusBar = null;
    private static String editor = I18n.tr((String)"SeaMap Editor", (Object[])new Object[0]);

    public SmedTabAction() {
        super(editor, "Smed", editor, null, true);
    }

    public void actionPerformed(ActionEvent e) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SmedTabAction.this.createAndShowTabs();
            }
        });
        this.isOpen = true;
        if (this.osmItem == null) {
            return;
        }
        this.osmItem.setEnabled(false);
    }

    protected void createAndShowTabs() {
        this.frame = new JFrame(editor);
        smedStatusBar = new JTextField();
        this.frame.setDefaultCloseOperation(2);
        this.frame.setResizable(false);
        this.frame.setAlwaysOnTop(true);
        this.frame.setJMenuBar(this.smedMenu);
        this.frame.add((Component)this.smedTabs, "Center");
        this.frame.add((Component)smedStatusBar, "Last");
        this.frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                SmedTabAction.this.osmItem.setEnabled(true);
                SmedTabAction.this.closeDialog();
            }
        });
        this.frame.setSize(new Dimension(420, 470));
        this.frame.setVisible(true);
    }

    public void closeDialog() {
        List<SmedPluggable> plugins = SmedTabbedPane.getPlugins();
        if (plugins != null) {
            for (SmedPluggable p : plugins) {
                p.stop();
            }
        }
        if (this.isOpen) {
            this.frame.setVisible(false);
            this.frame.dispose();
        }
        this.isOpen = false;
    }

    public void setOsmItem(JMenuItem item) {
        this.osmItem = item;
    }
}

