/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.MultiHashMap;
import org.apache.commons.collections.MultiMap;
import org.apache.commons.collections.map.MultiValueMap;
import org.jopendocument.util.CopyUtils;
import org.jopendocument.util.ExceptionUtils;

public class CollectionMap<K, V>
extends MultiHashMap {
    private static final int DEFAULT_CAPACITY = 16;
    private final Class<? extends Collection<V>> collectionClass;
    private final Collection<V> collectionSpecimen;

    public CollectionMap() {
        this(ArrayList.class);
    }

    public CollectionMap(Class clazz) {
        this(clazz, 16);
    }

    public CollectionMap(int n) {
        this(null, n);
    }

    public CollectionMap(Class clazz, int n) {
        super(n);
        this.collectionClass = clazz;
        this.collectionSpecimen = null;
        new MultiValueMap();
    }

    @Override
    public Collection<V> createCollection(Collection collection) {
        if (this.collectionClass != null) {
            try {
                if (collection == null) {
                    return this.collectionClass.newInstance();
                }
                return this.collectionClass.getConstructor(Collection.class).newInstance(collection);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        if (this.collectionSpecimen != null) {
            try {
                Collection<V> collection2 = CopyUtils.copy(this.collectionSpecimen);
                if (collection != null) {
                    collection2.addAll(collection);
                }
                return collection2;
            }
            catch (Exception exception) {
                throw ExceptionUtils.createExn(IllegalStateException.class, "clone() failed", exception);
            }
        }
        return super.createCollection(collection);
    }

    public void merge(MultiMap multiMap) {
        for (Map.Entry entry : multiMap.entrySet()) {
            Collection collection = (Collection)entry.getValue();
            Collection<V> collection2 = this.createCollection(collection);
            this.putAll(entry.getKey(), collection2);
        }
    }

    @Override
    public void putAll(Map map) {
        if (map instanceof MultiMap) {
            this.merge((MultiMap)map);
        } else {
            super.putAll(map);
        }
    }

    public boolean putAll(K k, V ... VArray) {
        return this.putAll((Object)k, Arrays.asList(VArray));
    }

    @Override
    public Set<Map.Entry<K, Collection<V>>> entrySet() {
        return super.entrySet();
    }

    @Override
    public Set<K> keySet() {
        return super.keySet();
    }

    @Override
    public Collection<V> values() {
        return super.values();
    }
}

