/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.resources;

import java.util.List;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.Ellipsoid;

public final class CRSUtilities {
    private CRSUtilities() {
    }

    private static List<CoordinateReferenceSystem> getComponents(CoordinateReferenceSystem crs) {
        List<CoordinateReferenceSystem> components;
        if (crs instanceof CompoundCRS && !(components = ((CompoundCRS)crs).getCoordinateReferenceSystems()).isEmpty()) {
            return components;
        }
        return null;
    }

    public static Datum getDatum(CoordinateReferenceSystem crs) {
        return crs instanceof SingleCRS ? ((SingleCRS)crs).getDatum() : null;
    }

    public static Ellipsoid getHeadGeoEllipsoid(CoordinateReferenceSystem crs) {
        while (!(crs instanceof GeographicCRS)) {
            List<CoordinateReferenceSystem> c = CRSUtilities.getComponents(crs);
            if (c == null) {
                return null;
            }
            crs = c.get(0);
        }
        return ((GeographicCRS)crs).getDatum().getEllipsoid();
    }
}

