/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.wkt;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import org.geotools.referencing.wkt.Element;
import org.geotools.referencing.wkt.Symbols;

public abstract class AbstractParser {
    private static final boolean SCIENTIFIC_NOTATION = true;
    final Symbols symbols;
    private final NumberFormat numberFormat;

    public AbstractParser(Symbols symbols) {
        DecimalFormat numberFormat;
        String pattern;
        this.symbols = symbols;
        this.numberFormat = (NumberFormat)symbols.numberFormat.clone();
        if (this.numberFormat instanceof DecimalFormat && (pattern = (numberFormat = (DecimalFormat)this.numberFormat).toPattern()).indexOf("E0") < 0) {
            int split = pattern.indexOf(59);
            if (split >= 0) {
                pattern = pattern.substring(0, split) + "E0" + pattern.substring(split);
            }
            pattern = pattern + "E0";
            numberFormat.applyPattern(pattern);
        }
    }

    public final Object parseObject(String text) throws ParseException {
        Element element = this.getTree(text, new ParsePosition(0));
        Object object = this.parse(element);
        element.close();
        return object;
    }

    final Number parseNumber(String text, ParsePosition position) {
        int i;
        int base = position.getIndex();
        Number number = this.numberFormat.parse(text, position);
        if (number != null && (i = position.getIndex()) < text.length() && text.charAt(i) == 'e') {
            StringBuilder buffer = new StringBuilder(text);
            buffer.setCharAt(i, 'E');
            text = buffer.toString();
            position.setIndex(base);
            number = this.numberFormat.parse(text, position);
        }
        return number;
    }

    protected abstract Object parse(Element var1) throws ParseException;

    protected final Element getTree(String text, ParsePosition position) throws ParseException {
        return new Element(new Element(this, text, position));
    }
}

