/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.parameter;

import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.measure.unit.Unit;
import org.geotools.parameter.DefaultParameterDescriptorGroup;
import org.geotools.resources.i18n.Errors;
import org.geotools.util.logging.Logging;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.InvalidParameterTypeException;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;

public final class Parameters {
    private static final double EPS = 1.0E-8;
    public static ParameterDescriptorGroup EMPTY_GROUP = new DefaultParameterDescriptorGroup("empty", new GeneralParameterDescriptor[0]);

    private Parameters() {
    }

    public static <T> ParameterDescriptor<T> cast(ParameterDescriptor<?> descriptor, Class<T> type) throws ClassCastException {
        Class<?> actual;
        if (descriptor != null && !type.equals(actual = descriptor.getValueClass())) {
            throw new ClassCastException(Errors.format(13, descriptor.getName().getCode(), actual));
        }
        return descriptor;
    }

    public static <T> ParameterValue<T> cast(ParameterValue<?> value, Class<T> type) throws ClassCastException {
        ParameterDescriptor<?> descriptor;
        Class<?> actual;
        if (value != null && !type.equals(actual = (descriptor = value.getDescriptor()).getValueClass())) {
            throw new ClassCastException(Errors.format(13, descriptor.getName().getCode(), actual));
        }
        return value;
    }

    public static boolean ensureSet(ParameterValueGroup parameters, String name, double value, Unit<?> unit, boolean force) {
        ParameterValue<?> parameter;
        try {
            parameter = parameters.parameter(name);
        }
        catch (ParameterNotFoundException ignore) {
            return false;
        }
        try {
            if (Math.abs(parameter.doubleValue(unit) / value - 1.0) <= 1.0E-8) {
                return false;
            }
        }
        catch (InvalidParameterTypeException exception) {
            return false;
        }
        catch (IllegalStateException exception) {
            parameter.setValue(value, unit);
            return true;
        }
        if (force) {
            parameter.setValue(value, unit);
        } else {
            LogRecord record = new LogRecord(Level.FINE, "Axis length mismatch.");
            record.setSourceClassName(Parameters.class.getName());
            record.setSourceMethodName("ensureSet");
            Logger logger = Logging.getLogger(Parameters.class);
            record.setLoggerName(logger.getName());
            logger.log(record);
        }
        return true;
    }
}

