/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.visitor;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import java.util.logging.Logger;
import org.geotools.filter.visitor.NullFilterVisitor;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.logging.Logging;
import org.opengis.filter.And;
import org.opengis.filter.ExcludeFilter;
import org.opengis.filter.Filter;
import org.opengis.filter.Id;
import org.opengis.filter.IncludeFilter;
import org.opengis.filter.Not;
import org.opengis.filter.Or;
import org.opengis.filter.expression.Add;
import org.opengis.filter.expression.Divide;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.Multiply;
import org.opengis.filter.expression.NilExpression;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.expression.Subtract;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class ExtractBoundsFilterVisitor
extends NullFilterVisitor {
    public static NullFilterVisitor BOUNDS_VISITOR = new ExtractBoundsFilterVisitor();
    private static Logger LOGGER = Logging.getLogger("org.geotools.index.rtree");

    protected ExtractBoundsFilterVisitor() {
    }

    private ReferencedEnvelope bbox(Object data) {
        if (data == null) {
            return null;
        }
        if (data instanceof ReferencedEnvelope) {
            return (ReferencedEnvelope)data;
        }
        if (data instanceof Envelope) {
            return new ReferencedEnvelope((Envelope)data, null);
        }
        if (data instanceof CoordinateReferenceSystem) {
            return new ReferencedEnvelope((CoordinateReferenceSystem)data);
        }
        throw new ClassCastException("Could not cast data to ReferencedEnvelope");
    }

    @Override
    public Object visit(ExcludeFilter filter, Object data) {
        return new Envelope();
    }

    @Override
    public Object visit(IncludeFilter filter, Object data) {
        return this.infinity();
    }

    Envelope infinity() {
        return new Envelope(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    @Override
    public Object visit(Literal expression, Object data) {
        ReferencedEnvelope bbox = this.bbox(data);
        Object value = expression.getValue();
        if (value instanceof Geometry) {
            Geometry geometry = (Geometry)value;
            Envelope bounds = geometry.getEnvelopeInternal();
            if (bbox != null) {
                bbox.expandToInclude(bounds);
                return bbox;
            }
            return this.bbox(bounds);
        }
        LOGGER.finer("LiteralExpression ignored!");
        return bbox;
    }

    @Override
    public Object visit(And filter, Object data) {
        Envelope mixed = this.infinity();
        for (Filter f : filter.getChildren()) {
            Envelope env = (Envelope)f.accept(this, data);
            mixed = mixed.intersection(env);
        }
        return mixed;
    }

    @Override
    public Object visit(Not filter, Object data) {
        return this.infinity();
    }

    @Override
    public Object visit(Or filter, Object data) {
        Envelope mixed = new Envelope();
        for (Filter f : filter.getChildren()) {
            Envelope env = (Envelope)f.accept(this, data);
            mixed.expandToInclude(env);
        }
        return mixed;
    }

    @Override
    public Object visit(Add expression, Object data) {
        return this.infinity();
    }

    @Override
    public Object visit(Divide expression, Object data) {
        return this.infinity();
    }

    @Override
    public Object visit(Function expression, Object data) {
        return this.infinity();
    }

    @Override
    public Object visit(Id filter, Object data) {
        return this.infinity();
    }

    @Override
    public Object visit(Multiply expression, Object data) {
        return this.infinity();
    }

    @Override
    public Object visit(NilExpression expression, Object data) {
        return this.infinity();
    }

    @Override
    public Object visit(PropertyName expression, Object data) {
        return null;
    }

    @Override
    public Object visit(Subtract expression, Object data) {
        return this.infinity();
    }

    @Override
    public Object visitNullFilter(Object data) {
        return this.infinity();
    }
}

