/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.store;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import java.util.ArrayList;
import java.util.Iterator;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.store.ReprojectingIterator;
import org.geotools.feature.FeatureTypes;
import org.geotools.feature.SchemaException;
import org.geotools.feature.collection.DecoratingSimpleFeatureCollection;
import org.geotools.feature.collection.DelegateSimpleFeatureIterator;
import org.geotools.geometry.jts.GeometryCoordinateSequenceTransformer;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.sort.SortBy;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;

public class ReprojectingFeatureCollection
extends DecoratingSimpleFeatureCollection {
    MathTransform transform;
    SimpleFeatureType schema;
    CoordinateReferenceSystem target;
    GeometryCoordinateSequenceTransformer transformer;

    public ReprojectingFeatureCollection(SimpleFeatureCollection delegate, CoordinateReferenceSystem target) {
        this(delegate, ((SimpleFeatureType)delegate.getSchema()).getGeometryDescriptor().getCoordinateReferenceSystem(), target);
    }

    public ReprojectingFeatureCollection(SimpleFeatureCollection delegate, CoordinateReferenceSystem source, CoordinateReferenceSystem target) {
        super(delegate);
        this.target = target;
        SimpleFeatureType schema = (SimpleFeatureType)delegate.getSchema();
        this.schema = this.reType(schema, target);
        if (source == null) {
            throw new NullPointerException("source crs");
        }
        if (target == null) {
            throw new NullPointerException("destination crs");
        }
        this.transform = this.transform(source, target);
        this.transformer = new GeometryCoordinateSequenceTransformer();
    }

    private MathTransform transform(CoordinateReferenceSystem source, CoordinateReferenceSystem target) {
        try {
            return CRS.findMathTransform(source, target);
        }
        catch (FactoryException e) {
            throw new IllegalArgumentException("Could not create math transform");
        }
    }

    private SimpleFeatureType reType(SimpleFeatureType type, CoordinateReferenceSystem target) {
        try {
            return FeatureTypes.transform(type, target);
        }
        catch (SchemaException e) {
            throw new IllegalArgumentException("Could not transform source schema", e);
        }
    }

    @Override
    public SimpleFeatureIterator features() {
        return new DelegateSimpleFeatureIterator(this, this.iterator());
    }

    @Override
    public Iterator<SimpleFeature> iterator() {
        try {
            return new ReprojectingIterator(this.delegate.iterator(), this.transform, this.schema, this.transformer);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close(Iterator close) {
        Iterator iterator = ((ReprojectingIterator)close).getDelegate();
        this.delegate.close(iterator);
    }

    @Override
    public SimpleFeatureType getSchema() {
        return this.schema;
    }

    @Override
    public SimpleFeatureCollection subCollection(Filter filter) {
        Filter unFilter = this.unFilter(filter);
        return new ReprojectingFeatureCollection(this.delegate.subCollection(unFilter), this.target);
    }

    private Filter unFilter(Filter filter) {
        return filter;
    }

    public SimpleFeatureCollection sort(SortBy order) {
        throw new UnsupportedOperationException("Not yet");
    }

    @Override
    public Object[] toArray() {
        return this.toArray(new Object[this.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] toArray(Object[] a) {
        ArrayList<SimpleFeature> list = new ArrayList<SimpleFeature>();
        Iterator<SimpleFeature> i = this.iterator();
        try {
            while (i.hasNext()) {
                list.add(i.next());
            }
            Object[] objectArray = list.toArray(a);
            return objectArray;
        }
        finally {
            this.close((Iterator)i);
        }
    }

    @Override
    public boolean add(SimpleFeature o) {
        throw new UnsupportedOperationException("Not yet");
    }

    @Override
    public ReferencedEnvelope getBounds() {
        SimpleFeatureIterator r = this.features();
        try {
            Envelope newBBox = new Envelope();
            while (r.hasNext()) {
                SimpleFeature feature = (SimpleFeature)r.next();
                Geometry geom = (Geometry)feature.getDefaultGeometry();
                if (geom == null) continue;
                Envelope internal = geom.getEnvelopeInternal();
                newBBox.expandToInclude(internal);
            }
            ReferencedEnvelope referencedEnvelope = ReferencedEnvelope.reference(newBBox);
            return referencedEnvelope;
        }
        catch (Exception e) {
            throw new RuntimeException("Exception occurred while computing reprojected bounds", e);
        }
        finally {
            r.close();
        }
    }
}

