/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile.shp;

import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import org.geotools.data.shapefile.shp.ShapeHandler;
import org.geotools.data.shapefile.shp.ShapeType;
import org.geotools.data.shapefile.shp.ShapefileException;

public class MultiLineHandler
implements ShapeHandler {
    final ShapeType shapeType;
    GeometryFactory geometryFactory;

    public MultiLineHandler(ShapeType type, GeometryFactory gf) throws ShapefileException {
        if (type != ShapeType.ARC && type != ShapeType.ARCM && type != ShapeType.ARCZ) {
            throw new ShapefileException("MultiLineHandler constructor - expected type to be 3,13 or 23");
        }
        this.shapeType = type;
        this.geometryFactory = gf;
    }

    private Object createNull() {
        return this.geometryFactory.createMultiLineString(null);
    }

    @Override
    public Object read(ByteBuffer buffer, ShapeType type, boolean flatGeometry) {
        int finish;
        int part;
        if (type == ShapeType.NULL) {
            return this.createNull();
        }
        int dimensions = this.shapeType == ShapeType.ARCZ && !flatGeometry ? 3 : 2;
        buffer.position(buffer.position() + 32);
        int numParts = buffer.getInt();
        int numPoints = buffer.getInt();
        int[] partOffsets = new int[numParts];
        for (int i = 0; i < numParts; ++i) {
            partOffsets[i] = buffer.getInt();
        }
        CoordinateSequence[] lines = new CoordinateSequence[numParts];
        int start = 0;
        int length = 0;
        boolean clonePoint = false;
        DoubleBuffer doubleBuffer = buffer.asDoubleBuffer();
        for (part = 0; part < numParts; ++part) {
            finish = part == numParts - 1 ? numPoints : partOffsets[part + 1];
            length = finish - (start = partOffsets[part]);
            if (length == 1) {
                length = 2;
                clonePoint = true;
            } else {
                clonePoint = false;
            }
            CoordinateSequence cs = this.geometryFactory.getCoordinateSequenceFactory().create(length, dimensions);
            double[] xy = new double[length * 2];
            doubleBuffer.get(xy);
            for (int i = 0; i < length; ++i) {
                cs.setOrdinate(i, 0, xy[i * 2]);
                cs.setOrdinate(i, 1, xy[i * 2 + 1]);
            }
            if (clonePoint) {
                cs.setOrdinate(1, 0, cs.getOrdinate(0, 0));
                cs.setOrdinate(1, 1, cs.getOrdinate(0, 1));
            }
            lines[part] = cs;
        }
        if (dimensions == 3) {
            doubleBuffer.position(doubleBuffer.position() + 2);
            for (part = 0; part < numParts; ++part) {
                finish = part == numParts - 1 ? numPoints : partOffsets[part + 1];
                length = finish - (start = partOffsets[part]);
                if (length == 1) {
                    length = 2;
                    clonePoint = true;
                } else {
                    clonePoint = false;
                }
                double[] z = new double[length];
                doubleBuffer.get(z);
                for (int i = 0; i < length; ++i) {
                    lines[part].setOrdinate(i, 2, z[i]);
                }
            }
        }
        LineString[] lineStrings = new LineString[numParts];
        for (int part2 = 0; part2 < numParts; ++part2) {
            lineStrings[part2] = this.geometryFactory.createLineString(lines[part2]);
        }
        return this.geometryFactory.createMultiLineString(lineStrings);
    }
}

