/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.poi.ss.util.MutableFPNumber;

final class NormalisedDecimal {
    private static final int EXPONENT_OFFSET = 14;
    private static final BigDecimal BD_2_POW_24 = new BigDecimal(BigInteger.ONE.shiftLeft(24));
    private static final int LOG_BASE_10_OF_2_TIMES_2_POW_20 = 315653;
    private static final int C_2_POW_19 = 524288;
    private static final int FRAC_HALF = 0x800000;
    private static final long MAX_REP_WHOLE_PART = 1000000000000000L;
    private final int _relativeDecimalExponent;
    private final long _wholePart;
    private final int _fractionalPart;

    public static NormalisedDecimal create(BigInteger bigInteger, int n) {
        int n2;
        if (n > 49 || n < 46) {
            int n3 = 0xE80000 - n * 315653;
            n2 = -((n3 += 524288) >> 20);
        } else {
            n2 = 0;
        }
        MutableFPNumber mutableFPNumber = new MutableFPNumber(bigInteger, n);
        if (n2 != 0) {
            mutableFPNumber.multiplyByPowerOfTen(-n2);
        }
        switch (mutableFPNumber.get64BitNormalisedExponent()) {
            case 46: {
                if (mutableFPNumber.isAboveMinRep()) break;
            }
            case 44: 
            case 45: {
                mutableFPNumber.multiplyByPowerOfTen(1);
                --n2;
                break;
            }
            case 47: 
            case 48: {
                break;
            }
            case 49: {
                if (mutableFPNumber.isBelowMaxRep()) break;
            }
            case 50: {
                mutableFPNumber.multiplyByPowerOfTen(-1);
                ++n2;
                break;
            }
            default: {
                throw new IllegalStateException("Bad binary exp " + mutableFPNumber.get64BitNormalisedExponent() + ".");
            }
        }
        mutableFPNumber.normalise64bit();
        return mutableFPNumber.createNormalisedDecimal(n2);
    }

    public NormalisedDecimal roundUnits() {
        long l = this._wholePart;
        if (this._fractionalPart >= 0x800000) {
            ++l;
        }
        int n = this._relativeDecimalExponent;
        if (l < 1000000000000000L) {
            return new NormalisedDecimal(l, 0, n);
        }
        return new NormalisedDecimal(l / 10L, 0, n + 1);
    }

    NormalisedDecimal(long l, int n, int n2) {
        this._wholePart = l;
        this._fractionalPart = n;
        this._relativeDecimalExponent = n2;
    }

    public String getSignificantDecimalDigits() {
        return Long.toString(this._wholePart);
    }

    public String getSignificantDecimalDigitsLastDigitRounded() {
        long l = this._wholePart + 5L;
        StringBuilder stringBuilder = new StringBuilder(24);
        stringBuilder.append(l);
        stringBuilder.setCharAt(stringBuilder.length() - 1, '0');
        return stringBuilder.toString();
    }

    public int getDecimalExponent() {
        return this._relativeDecimalExponent + 14;
    }

    public BigDecimal getFractionalPart() {
        return new BigDecimal(this._fractionalPart).divide(BD_2_POW_24);
    }

    private String getFractionalDigits() {
        if (this._fractionalPart == 0) {
            return "0";
        }
        return this.getFractionalPart().toString().substring(2);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append(" [");
        String string = String.valueOf(this._wholePart);
        stringBuilder.append(string.charAt(0));
        stringBuilder.append('.');
        stringBuilder.append(string.substring(1));
        stringBuilder.append(' ');
        stringBuilder.append(this.getFractionalDigits());
        stringBuilder.append("E");
        stringBuilder.append(this.getDecimalExponent());
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

