/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.StandardRecord;
import org.apache.poi.hssf.record.common.UnicodeString;
import org.apache.poi.hssf.record.formula.Ptg;
import org.apache.poi.ss.formula.Formula;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.util.LittleEndianOutput;
import org.apache.poi.util.StringUtil;

public final class DVRecord
extends StandardRecord {
    public static final short sid = 446;
    private int _option_flags;
    private UnicodeString _promptTitle;
    private UnicodeString _errorTitle;
    private UnicodeString _promptText;
    private UnicodeString _errorText;
    private short _not_used_1 = (short)16352;
    private Formula _formula1;
    private short _not_used_2 = 0;
    private Formula _formula2;
    private CellRangeAddressList _regions;

    public DVRecord(RecordInputStream recordInputStream) {
        this._option_flags = recordInputStream.readInt();
        this._promptTitle = DVRecord.readUnicodeString(recordInputStream);
        this._errorTitle = DVRecord.readUnicodeString(recordInputStream);
        this._promptText = DVRecord.readUnicodeString(recordInputStream);
        this._errorText = DVRecord.readUnicodeString(recordInputStream);
        int n = recordInputStream.readUShort();
        this._not_used_1 = recordInputStream.readShort();
        this._formula1 = Formula.read(n, recordInputStream);
        int n2 = recordInputStream.readUShort();
        this._not_used_2 = recordInputStream.readShort();
        this._formula2 = Formula.read(n2, recordInputStream);
        this._regions = new CellRangeAddressList(recordInputStream);
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[DV]\n");
        stringBuffer.append(" options=").append(Integer.toHexString(this._option_flags));
        stringBuffer.append(" title-prompt=").append(DVRecord.formatTextTitle(this._promptTitle));
        stringBuffer.append(" title-error=").append(DVRecord.formatTextTitle(this._errorTitle));
        stringBuffer.append(" text-prompt=").append(DVRecord.formatTextTitle(this._promptText));
        stringBuffer.append(" text-error=").append(DVRecord.formatTextTitle(this._errorText));
        stringBuffer.append("\n");
        DVRecord.appendFormula(stringBuffer, "Formula 1:", this._formula1);
        DVRecord.appendFormula(stringBuffer, "Formula 2:", this._formula2);
        stringBuffer.append("Regions: ");
        int n = this._regions.countRanges();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            CellRangeAddress cellRangeAddress = this._regions.getCellRangeAddress(i);
            stringBuffer.append('(').append(cellRangeAddress.getFirstRow()).append(',').append(cellRangeAddress.getLastRow());
            stringBuffer.append(',').append(cellRangeAddress.getFirstColumn()).append(',').append(cellRangeAddress.getLastColumn()).append(')');
        }
        stringBuffer.append("\n");
        stringBuffer.append("[/DV]");
        return stringBuffer.toString();
    }

    private static String formatTextTitle(UnicodeString unicodeString) {
        String string = unicodeString.getString();
        if (string.length() == 1 && string.charAt(0) == '\u0000') {
            return "'\\0'";
        }
        return string;
    }

    private static void appendFormula(StringBuffer stringBuffer, String string, Formula formula) {
        stringBuffer.append(string);
        if (formula == null) {
            stringBuffer.append("<empty>\n");
            return;
        }
        Ptg[] ptgArray = formula.getTokens();
        stringBuffer.append('\n');
        for (int i = 0; i < ptgArray.length; ++i) {
            stringBuffer.append('\t').append(ptgArray[i].toString()).append('\n');
        }
    }

    @Override
    public void serialize(LittleEndianOutput littleEndianOutput) {
        littleEndianOutput.writeInt(this._option_flags);
        DVRecord.serializeUnicodeString(this._promptTitle, littleEndianOutput);
        DVRecord.serializeUnicodeString(this._errorTitle, littleEndianOutput);
        DVRecord.serializeUnicodeString(this._promptText, littleEndianOutput);
        DVRecord.serializeUnicodeString(this._errorText, littleEndianOutput);
        littleEndianOutput.writeShort(this._formula1.getEncodedTokenSize());
        littleEndianOutput.writeShort(this._not_used_1);
        this._formula1.serializeTokens(littleEndianOutput);
        littleEndianOutput.writeShort(this._formula2.getEncodedTokenSize());
        littleEndianOutput.writeShort(this._not_used_2);
        this._formula2.serializeTokens(littleEndianOutput);
        this._regions.serialize(littleEndianOutput);
    }

    private static UnicodeString readUnicodeString(RecordInputStream recordInputStream) {
        return new UnicodeString(recordInputStream);
    }

    private static void serializeUnicodeString(UnicodeString unicodeString, LittleEndianOutput littleEndianOutput) {
        StringUtil.writeUnicodeString(littleEndianOutput, unicodeString.getString());
    }

    private static int getUnicodeStringSize(UnicodeString unicodeString) {
        String string = unicodeString.getString();
        return 3 + string.length() * (StringUtil.hasMultibyte(string) ? 2 : 1);
    }

    @Override
    protected int getDataSize() {
        int n = 12;
        n += DVRecord.getUnicodeStringSize(this._promptTitle);
        n += DVRecord.getUnicodeStringSize(this._errorTitle);
        n += DVRecord.getUnicodeStringSize(this._promptText);
        n += DVRecord.getUnicodeStringSize(this._errorText);
        n += this._formula1.getEncodedTokenSize();
        n += this._formula2.getEncodedTokenSize();
        return n += this._regions.getSize();
    }

    @Override
    public short getSid() {
        return 446;
    }

    @Override
    public Object clone() {
        return this.cloneViaReserialise();
    }
}

