/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.valid;

import com.vividsolutions.jts.algorithm.LineIntersector;
import com.vividsolutions.jts.algorithm.RobustLineIntersector;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geomgraph.GeometryGraph;
import com.vividsolutions.jts.geomgraph.index.SegmentIntersector;
import com.vividsolutions.jts.operation.relate.EdgeEndBundle;
import com.vividsolutions.jts.operation.relate.RelateNode;
import com.vividsolutions.jts.operation.relate.RelateNodeGraph;
import java.util.Iterator;

public class ConsistentAreaTester {
    private final LineIntersector li = new RobustLineIntersector();
    private GeometryGraph geomGraph;
    private RelateNodeGraph nodeGraph = new RelateNodeGraph();
    private Coordinate invalidPoint;

    public ConsistentAreaTester(GeometryGraph geometryGraph) {
        this.geomGraph = geometryGraph;
    }

    public Coordinate getInvalidPoint() {
        return this.invalidPoint;
    }

    public boolean isNodeConsistentArea() {
        SegmentIntersector segmentIntersector = this.geomGraph.computeSelfNodes(this.li, true);
        if (segmentIntersector.hasProperIntersection()) {
            this.invalidPoint = segmentIntersector.getProperIntersectionPoint();
            return false;
        }
        this.nodeGraph.build(this.geomGraph);
        return this.isNodeEdgeAreaLabelsConsistent();
    }

    private boolean isNodeEdgeAreaLabelsConsistent() {
        Iterator iterator = this.nodeGraph.getNodeIterator();
        while (iterator.hasNext()) {
            RelateNode relateNode = (RelateNode)iterator.next();
            if (relateNode.getEdges().isAreaLabelsConsistent(this.geomGraph)) continue;
            this.invalidPoint = (Coordinate)relateNode.getCoordinate().clone();
            return false;
        }
        return true;
    }

    public boolean hasDuplicateRings() {
        Iterator iterator = this.nodeGraph.getNodeIterator();
        while (iterator.hasNext()) {
            RelateNode relateNode = (RelateNode)iterator.next();
            Iterator iterator2 = relateNode.getEdges().iterator();
            while (iterator2.hasNext()) {
                EdgeEndBundle edgeEndBundle = (EdgeEndBundle)iterator2.next();
                if (edgeEndBundle.getEdgeEnds().size() <= 1) continue;
                this.invalidPoint = edgeEndBundle.getEdge().getCoordinate(0);
                return true;
            }
        }
        return false;
    }
}

