/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.index.quadtree;

public class DoubleBits {
    public static final int EXPONENT_BIAS = 1023;
    private double x;
    private long xBits;

    public static double powerOf2(int n) {
        if (n > 1023 || n < -1022) {
            throw new IllegalArgumentException("Exponent out of bounds");
        }
        long l = n + 1023;
        long l2 = l << 52;
        return Double.longBitsToDouble(l2);
    }

    public static int exponent(double d) {
        DoubleBits doubleBits = new DoubleBits(d);
        return doubleBits.getExponent();
    }

    public DoubleBits(double d) {
        this.x = d;
        this.xBits = Double.doubleToLongBits(d);
    }

    public int biasedExponent() {
        int n = (int)(this.xBits >> 52);
        int n2 = n & 0x7FF;
        return n2;
    }

    public int getExponent() {
        return this.biasedExponent() - 1023;
    }

    public String toString() {
        String string = Long.toBinaryString(this.xBits);
        String string2 = "0000000000000000000000000000000000000000000000000000000000000000";
        String string3 = string2 + string;
        String string4 = string3.substring(string3.length() - 64);
        String string5 = string4.substring(0, 1) + "  " + string4.substring(1, 12) + "(" + this.getExponent() + ") " + string4.substring(12) + " [ " + this.x + " ]";
        return string5;
    }
}

