/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geomgraph;

import com.vividsolutions.jts.geomgraph.Label;

public class Depth {
    private static final int NULL_VALUE = -1;
    private int[][] depth = new int[2][3];

    public static int depthAtLocation(int n) {
        if (n == 2) {
            return 0;
        }
        if (n == 0) {
            return 1;
        }
        return -1;
    }

    public Depth() {
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.depth[i][j] = -1;
            }
        }
    }

    public int getLocation(int n, int n2) {
        if (this.depth[n][n2] <= 0) {
            return 2;
        }
        return 0;
    }

    public boolean isNull() {
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 3; ++j) {
                if (this.depth[i][j] == -1) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isNull(int n) {
        return this.depth[n][1] == -1;
    }

    public boolean isNull(int n, int n2) {
        return this.depth[n][n2] == -1;
    }

    public void add(Label label) {
        for (int i = 0; i < 2; ++i) {
            for (int j = 1; j < 3; ++j) {
                int n = label.getLocation(i, j);
                if (n != 2 && n != 0) continue;
                if (this.isNull(i, j)) {
                    this.depth[i][j] = Depth.depthAtLocation(n);
                    continue;
                }
                int[] nArray = this.depth[i];
                int n2 = j;
                nArray[n2] = nArray[n2] + Depth.depthAtLocation(n);
            }
        }
    }

    public int getDelta(int n) {
        return this.depth[n][2] - this.depth[n][1];
    }

    public void normalize() {
        for (int i = 0; i < 2; ++i) {
            if (this.isNull(i)) continue;
            int n = this.depth[i][1];
            if (this.depth[i][2] < n) {
                n = this.depth[i][2];
            }
            if (n < 0) {
                n = 0;
            }
            for (int j = 1; j < 3; ++j) {
                int n2 = 0;
                if (this.depth[i][j] > n) {
                    n2 = 1;
                }
                this.depth[i][j] = n2;
            }
        }
    }

    public String toString() {
        return "A: " + this.depth[0][1] + "," + this.depth[0][2] + " B: " + this.depth[1][1] + "," + this.depth[1][2];
    }
}

