/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom;

import com.vividsolutions.jts.geom.Coordinate;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class PrecisionModel
implements Serializable,
Comparable<PrecisionModel> {
    private static final long serialVersionUID = 7777263578777803835L;
    public static final Type FIXED = new Type("FIXED");
    public static final Type FLOATING = new Type("FLOATING");
    public static final Type FLOATING_SINGLE = new Type("FLOATING SINGLE");
    private Type modelType = FLOATING;
    private double scale;

    public int getMaximumSignificantDigits() {
        int n = 16;
        if (this.modelType == FLOATING) {
            n = 16;
        } else if (this.modelType == FLOATING_SINGLE) {
            n = 6;
        } else if (this.modelType == FIXED) {
            n = 1 + (int)Math.ceil(Math.log(this.getScale()) / Math.log(10.0));
        }
        return n;
    }

    public double getScale() {
        return this.scale;
    }

    public Type getType() {
        return this.modelType;
    }

    public double makePrecise(double d) {
        if (Double.isNaN(d)) {
            return d;
        }
        if (this.modelType == FLOATING_SINGLE) {
            float f = (float)d;
            return f;
        }
        if (this.modelType == FIXED) {
            return (double)Math.round(d * this.scale) / this.scale;
        }
        return d;
    }

    public void makePrecise(Coordinate coordinate) {
        if (this.modelType == FLOATING) {
            return;
        }
        coordinate.x = this.makePrecise(coordinate.x);
        coordinate.y = this.makePrecise(coordinate.y);
    }

    public String toString() {
        String string = "UNKNOWN";
        if (this.modelType == FLOATING) {
            string = "Floating";
        } else if (this.modelType == FLOATING_SINGLE) {
            string = "Floating-Single";
        } else if (this.modelType == FIXED) {
            string = "Fixed (Scale=" + this.getScale() + ")";
        }
        return string;
    }

    public boolean equals(Object object) {
        if (!(object instanceof PrecisionModel)) {
            return false;
        }
        PrecisionModel precisionModel = (PrecisionModel)object;
        return this.modelType == precisionModel.modelType && this.scale == precisionModel.scale;
    }

    @Override
    public int compareTo(PrecisionModel precisionModel) {
        int n = this.getMaximumSignificantDigits();
        int n2 = precisionModel.getMaximumSignificantDigits();
        return new Integer(n).compareTo(new Integer(n2));
    }

    public static class Type
    implements Serializable {
        private static final long serialVersionUID = -5528602631731589822L;
        private static Map<String, Type> nameToTypeMap = new HashMap<String, Type>();
        private String name;

        public Type(String string) {
            this.name = string;
            nameToTypeMap.put(string, this);
        }

        public String toString() {
            return this.name;
        }

        private Object readResolve() {
            return nameToTypeMap.get(this.name);
        }
    }
}

