/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.algorithm;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.algorithm.CentralEndpointIntersector;
import com.vividsolutions.jts.algorithm.HCoordinate;
import com.vividsolutions.jts.algorithm.LineIntersector;
import com.vividsolutions.jts.algorithm.NotRepresentableException;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;

public class RobustLineIntersector
extends LineIntersector {
    @Override
    public void computeIntersection(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3) {
        this.isProper = false;
        if (Envelope.intersects(coordinate2, coordinate3, coordinate) && CGAlgorithms.orientationIndex(coordinate2, coordinate3, coordinate) == 0 && CGAlgorithms.orientationIndex(coordinate3, coordinate2, coordinate) == 0) {
            this.isProper = true;
            if (coordinate.equals(coordinate2) || coordinate.equals(coordinate3)) {
                this.isProper = false;
            }
            this.result = 1;
            return;
        }
        this.result = 0;
    }

    @Override
    protected int computeIntersect(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3, Coordinate coordinate4) {
        boolean bl;
        this.isProper = false;
        if (!Envelope.intersects(coordinate, coordinate2, coordinate3, coordinate4)) {
            return 0;
        }
        int n = CGAlgorithms.orientationIndex(coordinate, coordinate2, coordinate3);
        int n2 = CGAlgorithms.orientationIndex(coordinate, coordinate2, coordinate4);
        if (n > 0 && n2 > 0 || n < 0 && n2 < 0) {
            return 0;
        }
        int n3 = CGAlgorithms.orientationIndex(coordinate3, coordinate4, coordinate);
        int n4 = CGAlgorithms.orientationIndex(coordinate3, coordinate4, coordinate2);
        if (n3 > 0 && n4 > 0 || n3 < 0 && n4 < 0) {
            return 0;
        }
        boolean bl2 = bl = n == 0 && n2 == 0 && n3 == 0 && n4 == 0;
        if (bl) {
            return this.computeCollinearIntersection(coordinate, coordinate2, coordinate3, coordinate4);
        }
        if (n == 0 || n2 == 0 || n3 == 0 || n4 == 0) {
            this.isProper = false;
            if (coordinate.equals2D(coordinate3) || coordinate.equals2D(coordinate4)) {
                this.intPt[0] = coordinate;
            } else if (coordinate2.equals2D(coordinate3) || coordinate2.equals2D(coordinate4)) {
                this.intPt[0] = coordinate2;
            } else if (n == 0) {
                this.intPt[0] = new Coordinate(coordinate3);
            } else if (n2 == 0) {
                this.intPt[0] = new Coordinate(coordinate4);
            } else if (n3 == 0) {
                this.intPt[0] = new Coordinate(coordinate);
            } else if (n4 == 0) {
                this.intPt[0] = new Coordinate(coordinate2);
            }
        } else {
            this.isProper = true;
            this.intPt[0] = this.intersection(coordinate, coordinate2, coordinate3, coordinate4);
        }
        return 1;
    }

    private int computeCollinearIntersection(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3, Coordinate coordinate4) {
        boolean bl = Envelope.intersects(coordinate, coordinate2, coordinate3);
        boolean bl2 = Envelope.intersects(coordinate, coordinate2, coordinate4);
        boolean bl3 = Envelope.intersects(coordinate3, coordinate4, coordinate);
        boolean bl4 = Envelope.intersects(coordinate3, coordinate4, coordinate2);
        if (bl && bl2) {
            this.intPt[0] = coordinate3;
            this.intPt[1] = coordinate4;
            return 2;
        }
        if (bl3 && bl4) {
            this.intPt[0] = coordinate;
            this.intPt[1] = coordinate2;
            return 2;
        }
        if (bl && bl3) {
            this.intPt[0] = coordinate3;
            this.intPt[1] = coordinate;
            return coordinate3.equals(coordinate) && !bl2 && !bl4 ? 1 : 2;
        }
        if (bl && bl4) {
            this.intPt[0] = coordinate3;
            this.intPt[1] = coordinate2;
            return coordinate3.equals(coordinate2) && !bl2 && !bl3 ? 1 : 2;
        }
        if (bl2 && bl3) {
            this.intPt[0] = coordinate4;
            this.intPt[1] = coordinate;
            return coordinate4.equals(coordinate) && !bl && !bl4 ? 1 : 2;
        }
        if (bl2 && bl4) {
            this.intPt[0] = coordinate4;
            this.intPt[1] = coordinate2;
            return coordinate4.equals(coordinate2) && !bl && !bl3 ? 1 : 2;
        }
        return 0;
    }

    private Coordinate intersection(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3, Coordinate coordinate4) {
        Coordinate coordinate5 = this.intersectionWithNormalization(coordinate, coordinate2, coordinate3, coordinate4);
        if (!this.isInSegmentEnvelopes(coordinate5)) {
            coordinate5 = CentralEndpointIntersector.getIntersection(coordinate, coordinate2, coordinate3, coordinate4);
        }
        if (this.precisionModel != null) {
            this.precisionModel.makePrecise(coordinate5);
        }
        return coordinate5;
    }

    private Coordinate intersectionWithNormalization(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3, Coordinate coordinate4) {
        Coordinate coordinate5 = new Coordinate(coordinate);
        Coordinate coordinate6 = new Coordinate(coordinate2);
        Coordinate coordinate7 = new Coordinate(coordinate3);
        Coordinate coordinate8 = new Coordinate(coordinate4);
        Coordinate coordinate9 = new Coordinate();
        this.normalizeToEnvCentre(coordinate5, coordinate6, coordinate7, coordinate8, coordinate9);
        Coordinate coordinate10 = this.safeHCoordinateIntersection(coordinate5, coordinate6, coordinate7, coordinate8);
        coordinate10.x += coordinate9.x;
        coordinate10.y += coordinate9.y;
        return coordinate10;
    }

    private Coordinate safeHCoordinateIntersection(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3, Coordinate coordinate4) {
        Coordinate coordinate5 = null;
        try {
            coordinate5 = HCoordinate.intersection(coordinate, coordinate2, coordinate3, coordinate4);
        }
        catch (NotRepresentableException notRepresentableException) {
            coordinate5 = CentralEndpointIntersector.getIntersection(coordinate, coordinate2, coordinate3, coordinate4);
        }
        return coordinate5;
    }

    private void normalizeToEnvCentre(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3, Coordinate coordinate4, Coordinate coordinate5) {
        double d = coordinate.x < coordinate2.x ? coordinate.x : coordinate2.x;
        double d2 = coordinate.y < coordinate2.y ? coordinate.y : coordinate2.y;
        double d3 = coordinate.x > coordinate2.x ? coordinate.x : coordinate2.x;
        double d4 = coordinate.y > coordinate2.y ? coordinate.y : coordinate2.y;
        double d5 = coordinate3.x < coordinate4.x ? coordinate3.x : coordinate4.x;
        double d6 = coordinate3.y < coordinate4.y ? coordinate3.y : coordinate4.y;
        double d7 = coordinate3.x > coordinate4.x ? coordinate3.x : coordinate4.x;
        double d8 = coordinate3.y > coordinate4.y ? coordinate3.y : coordinate4.y;
        double d9 = d > d5 ? d : d5;
        double d10 = d3 < d7 ? d3 : d7;
        double d11 = d2 > d6 ? d2 : d6;
        double d12 = d4 < d8 ? d4 : d8;
        double d13 = (d9 + d10) / 2.0;
        double d14 = (d11 + d12) / 2.0;
        coordinate5.x = d13;
        coordinate5.y = d14;
        coordinate.x -= coordinate5.x;
        coordinate.y -= coordinate5.y;
        coordinate2.x -= coordinate5.x;
        coordinate2.y -= coordinate5.y;
        coordinate3.x -= coordinate5.x;
        coordinate3.y -= coordinate5.y;
        coordinate4.x -= coordinate5.x;
        coordinate4.y -= coordinate5.y;
    }

    private boolean isInSegmentEnvelopes(Coordinate coordinate) {
        Envelope envelope = new Envelope(this.inputLines[0][0], this.inputLines[0][1]);
        Envelope envelope2 = new Envelope(this.inputLines[1][0], this.inputLines[1][1]);
        return envelope.contains(coordinate) && envelope2.contains(coordinate);
    }
}

