/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.modules.fr.lemans.datasets;

import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.plugins.opendata.modules.fr.lemans.datasets.LeMansDataSetHandler;

public class CommunesHandler
extends LeMansDataSetHandler {
    public CommunesHandler() {
        super("F7B756B1-550EA533-37695DD8-FE094AE7");
        this.setName("Communes");
        this.setKmzShpUuid("64527774-550EA533-7E7BB44A-FD17EEF0", "6452D942-550EA533-7E7BB44A-C184920B");
    }

    public boolean acceptsFilename(String filename) {
        return this.acceptsKmzShpFilename(filename, new String[]{"LIMITES_DE_COMMUNES"}) || this.acceptsZipFilename(filename, new String[]{"Les limites de communes .*"});
    }

    public void updateDataSet(DataSet ds) {
        for (OsmPrimitive p : ds.allPrimitives()) {
            if (!p.hasKey("CODCOM")) continue;
            p.put("type", "boundary");
            p.put("boundary", "administrative");
            p.put("admin_level", "8");
            this.replace((IPrimitive)p, "COMMUNE", "name");
            p.remove("COMMUNE_2");
            this.replace((IPrimitive)p, "ID", "ref:INSEE");
            p.remove("CODCOM");
        }
    }
}

