/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.modules.fr.toulouse.datasets;

import java.net.MalformedURLException;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.plugins.opendata.core.datasets.fr.FrenchDataSetHandler;
import org.openstreetmap.josm.plugins.opendata.core.licenses.License;
import org.openstreetmap.josm.plugins.opendata.modules.fr.toulouse.ToulouseConstants;
import org.openstreetmap.josm.plugins.opendata.modules.fr.toulouse.ToulouseLicense;

public abstract class ToulouseDataSetHandler
extends FrenchDataSetHandler
implements ToulouseConstants {
    public ToulouseDataSetHandler(int portalId) {
        this.init(portalId);
    }

    public ToulouseDataSetHandler(int portalId, String relevantTag) {
        super(relevantTag);
        this.init(portalId);
    }

    public ToulouseDataSetHandler(int portalId, boolean relevantUnion, String ... relevantTags) {
        super(relevantUnion, relevantTags);
        this.init(portalId);
    }

    public ToulouseDataSetHandler(int portalId, String ... relevantTags) {
        this(portalId, false, relevantTags);
    }

    public ToulouseDataSetHandler(int portalId, boolean relevantUnion, Tag ... relevantTags) {
        super(relevantUnion, relevantTags);
        this.init(portalId);
    }

    private final void init(int portalId) {
        try {
            this.setLicense((License)new ToulouseLicense());
            if (portalId > 0) {
                String url = "http://data.grandtoulouse.fr/les-donnees/-/opendata/card/" + portalId + "--";
                this.setLocalPortalURL(url);
                this.setDataURL(url + "/resource/document");
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    public String getSource() {
        return "GrandToulouse";
    }

    public String getLocalPortalIconName() {
        return "data.fr.toulouse_24.png";
    }

    public String getDataLayerIconName() {
        return "data.fr.toulouse_16.png";
    }

    protected final void setWikiPage(String wikiPage) {
        if (wikiPage != null && !wikiPage.isEmpty()) {
            this.setName(wikiPage.replace("_", " "));
            try {
                this.setWikiURL("http://wiki.openstreetmap.org/wiki/Toulouse/GrandToulouseData/" + wikiPage.replace(" ", "_"));
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
    }
}

