/*
 * Decompiled with CFR 0.152.
 */
package org.jdom.input;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.jdom.DefaultJDOMFactory;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.JDOMFactory;
import org.jdom.input.BuilderErrorHandler;
import org.jdom.input.JDOMParseException;
import org.jdom.input.SAXHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLFilter;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class SAXBuilder {
    private static final String DEFAULT_SAX_DRIVER = "org.apache.xerces.parsers.SAXParser";
    private boolean validate;
    private boolean expand = true;
    private String saxDriverClass;
    private ErrorHandler saxErrorHandler = null;
    private EntityResolver saxEntityResolver = null;
    private DTDHandler saxDTDHandler = null;
    private XMLFilter saxXMLFilter = null;
    private JDOMFactory factory = new DefaultJDOMFactory();
    private boolean ignoringWhite = false;
    private boolean ignoringBoundaryWhite = false;
    private HashMap features = new HashMap(5);
    private HashMap properties = new HashMap(5);
    private boolean fastReconfigure = false;
    private boolean skipNextLexicalReportingConfig = false;
    private boolean skipNextEntityExpandConfig = false;
    private boolean reuseParser = true;
    private XMLReader saxParser = null;

    public SAXBuilder() {
        this(false);
    }

    public SAXBuilder(boolean bl) {
        this.validate = bl;
    }

    public Document build(InputSource inputSource) throws JDOMException, IOException {
        SAXHandler sAXHandler = null;
        try {
            Object object;
            sAXHandler = this.createContentHandler();
            this.configureContentHandler(sAXHandler);
            XMLReader xMLReader = this.saxParser;
            if (xMLReader == null) {
                xMLReader = this.createParser();
                if (this.saxXMLFilter != null) {
                    object = this.saxXMLFilter;
                    while (object.getParent() instanceof XMLFilter) {
                        object = (XMLFilter)object.getParent();
                    }
                    object.setParent(xMLReader);
                    xMLReader = this.saxXMLFilter;
                }
                this.configureParser(xMLReader, sAXHandler);
                if (this.reuseParser) {
                    this.saxParser = xMLReader;
                }
            } else {
                this.configureParser(xMLReader, sAXHandler);
            }
            xMLReader.parse(inputSource);
            object = sAXHandler.getDocument();
            return object;
        }
        catch (SAXParseException sAXParseException) {
            String string;
            Document document = sAXHandler.getDocument();
            if (!document.hasRootElement()) {
                document = null;
            }
            if ((string = sAXParseException.getSystemId()) != null) {
                throw new JDOMParseException("Error on line " + sAXParseException.getLineNumber() + " of document " + string, sAXParseException, document);
            }
            throw new JDOMParseException("Error on line " + sAXParseException.getLineNumber(), sAXParseException, document);
        }
        catch (SAXException sAXException) {
            throw new JDOMParseException("Error in building: " + sAXException.getMessage(), sAXException, sAXHandler.getDocument());
        }
        finally {
            sAXHandler = null;
        }
    }

    protected SAXHandler createContentHandler() {
        SAXHandler sAXHandler = new SAXHandler(this.factory);
        return sAXHandler;
    }

    protected void configureContentHandler(SAXHandler sAXHandler) {
        sAXHandler.setExpandEntities(this.expand);
        sAXHandler.setIgnoringElementContentWhitespace(this.ignoringWhite);
        sAXHandler.setIgnoringBoundaryWhitespace(this.ignoringBoundaryWhite);
    }

    protected XMLReader createParser() throws JDOMException {
        XMLReader xMLReader = null;
        if (this.saxDriverClass != null) {
            try {
                xMLReader = XMLReaderFactory.createXMLReader(this.saxDriverClass);
                this.setFeaturesAndProperties(xMLReader, true);
            }
            catch (SAXException sAXException) {
                throw new JDOMException("Could not load " + this.saxDriverClass, sAXException);
            }
        }
        try {
            Class<?> clazz = Class.forName("org.jdom.input.JAXPParserFactory");
            Method method = clazz.getMethod("createParser", Boolean.TYPE, Map.class, Map.class);
            xMLReader = (XMLReader)method.invoke(null, this.validate ? Boolean.TRUE : Boolean.FALSE, this.features, this.properties);
            this.setFeaturesAndProperties(xMLReader, false);
        }
        catch (JDOMException jDOMException) {
            throw jDOMException;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (xMLReader == null) {
            try {
                xMLReader = XMLReaderFactory.createXMLReader(DEFAULT_SAX_DRIVER);
                this.saxDriverClass = xMLReader.getClass().getName();
                this.setFeaturesAndProperties(xMLReader, true);
            }
            catch (SAXException sAXException) {
                throw new JDOMException("Could not load default SAX parser: org.apache.xerces.parsers.SAXParser", sAXException);
            }
        }
        return xMLReader;
    }

    protected void configureParser(XMLReader xMLReader, SAXHandler sAXHandler) throws JDOMException {
        boolean bl;
        xMLReader.setContentHandler(sAXHandler);
        if (this.saxEntityResolver != null) {
            xMLReader.setEntityResolver(this.saxEntityResolver);
        }
        if (this.saxDTDHandler != null) {
            xMLReader.setDTDHandler(this.saxDTDHandler);
        } else {
            xMLReader.setDTDHandler(sAXHandler);
        }
        if (this.saxErrorHandler != null) {
            xMLReader.setErrorHandler(this.saxErrorHandler);
        } else {
            xMLReader.setErrorHandler(new BuilderErrorHandler());
        }
        if (!this.skipNextLexicalReportingConfig) {
            bl = false;
            try {
                xMLReader.setProperty("http://xml.org/sax/handlers/LexicalHandler", sAXHandler);
                bl = true;
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
                // empty catch block
            }
            if (!bl) {
                try {
                    xMLReader.setProperty("http://xml.org/sax/properties/lexical-handler", sAXHandler);
                    bl = true;
                }
                catch (SAXNotSupportedException sAXNotSupportedException) {
                }
                catch (SAXNotRecognizedException sAXNotRecognizedException) {
                    // empty catch block
                }
            }
            if (!bl && this.fastReconfigure) {
                this.skipNextLexicalReportingConfig = true;
            }
        }
        if (!this.skipNextEntityExpandConfig) {
            bl = false;
            if (!this.expand) {
                try {
                    xMLReader.setProperty("http://xml.org/sax/properties/declaration-handler", sAXHandler);
                    bl = true;
                }
                catch (SAXNotSupportedException sAXNotSupportedException) {
                }
                catch (SAXNotRecognizedException sAXNotRecognizedException) {
                    // empty catch block
                }
            }
            if (!bl && this.fastReconfigure) {
                this.skipNextEntityExpandConfig = true;
            }
        }
    }

    private void setFeaturesAndProperties(XMLReader xMLReader, boolean bl) throws JDOMException {
        for (String string : this.features.keySet()) {
            Boolean bl2 = (Boolean)this.features.get(string);
            this.internalSetFeature(xMLReader, string, bl2, string);
        }
        for (String string : this.properties.keySet()) {
            this.internalSetProperty(xMLReader, string, this.properties.get(string), string);
        }
        if (bl) {
            block9: {
                try {
                    this.internalSetFeature(xMLReader, "http://xml.org/sax/features/validation", this.validate, "Validation");
                }
                catch (JDOMException jDOMException) {
                    if (!this.validate) break block9;
                    throw jDOMException;
                }
            }
            this.internalSetFeature(xMLReader, "http://xml.org/sax/features/namespaces", true, "Namespaces");
            this.internalSetFeature(xMLReader, "http://xml.org/sax/features/namespace-prefixes", true, "Namespace prefixes");
        }
        try {
            if (xMLReader.getFeature("http://xml.org/sax/features/external-general-entities") != this.expand) {
                xMLReader.setFeature("http://xml.org/sax/features/external-general-entities", this.expand);
            }
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            // empty catch block
        }
    }

    private void internalSetFeature(XMLReader xMLReader, String string, boolean bl, String string2) throws JDOMException {
        try {
            xMLReader.setFeature(string, bl);
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            throw new JDOMException(string2 + " feature not supported for SAX driver " + xMLReader.getClass().getName());
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            throw new JDOMException(string2 + " feature not recognized for SAX driver " + xMLReader.getClass().getName());
        }
    }

    private void internalSetProperty(XMLReader xMLReader, String string, Object object, String string2) throws JDOMException {
        try {
            xMLReader.setProperty(string, object);
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            throw new JDOMException(string2 + " property not supported for SAX driver " + xMLReader.getClass().getName());
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            throw new JDOMException(string2 + " property not recognized for SAX driver " + xMLReader.getClass().getName());
        }
    }

    public Document build(InputStream inputStream) throws JDOMException, IOException {
        return this.build(new InputSource(inputStream));
    }
}

