/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.index.quadtree.fs;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.logging.Logger;
import org.geotools.index.quadtree.StoreException;
import org.geotools.util.logging.Logging;

public class IndexHeader {
    public static final byte LSB_ORDER = -1;
    public static final byte MSB_ORDER = -2;
    public static final byte NATIVE_ORDER = 0;
    public static final byte NEW_LSB_ORDER = 1;
    public static final byte NEW_MSB_ORDER = 2;
    private static final String SIGNATURE = "SQT";
    private static final Logger LOGGER = Logging.getLogger("org.geotools.index.quadtree");
    private byte byteOrder;

    public IndexHeader(ReadableByteChannel channel) throws IOException, StoreException {
        ByteBuffer buf = ByteBuffer.allocate(8);
        channel.read(buf);
        buf.flip();
        byte[] tmp = new byte[3];
        buf.get(tmp);
        String s = new String(tmp, "US-ASCII");
        if (!s.equals(SIGNATURE)) {
            LOGGER.warning("Old qix file format; this file format is deprecated; It is strongly recommended to regenerate it in new format.");
            buf.position(0);
            tmp = buf.array();
            boolean lsb = tmp[4] == 0 && tmp[5] == 0 && tmp[6] == 0 && tmp[7] == 0 ? tmp[0] != 0 || tmp[1] != 0 : tmp[4] != 0 || tmp[5] != 0;
            this.byteOrder = (byte)(lsb ? -1 : -2);
        } else {
            this.byteOrder = buf.get();
        }
    }

    public byte getByteOrder() {
        return this.byteOrder;
    }
}

