/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile.dbf;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import org.geotools.resources.NIOUtilities;

public class DbaseFileHeader {
    private static final int FILE_DESCRIPTOR_SIZE = 32;
    private static final byte MAGIC = 3;
    private Date date = new Date();
    private int recordCnt = 0;
    private int fieldCnt = 0;
    private int recordLength = 1;
    private int headerLength = -1;
    private int largestFieldSize = 0;
    public static long MILLIS_SINCE_4713 = -210866803200000L;
    private DbaseField[] fields = new DbaseField[0];

    private void read(ByteBuffer buffer, ReadableByteChannel channel) throws IOException {
        while (buffer.remaining() > 0) {
            if (channel.read(buffer) != -1) continue;
            throw new EOFException("Premature end of file");
        }
    }

    public Class getFieldClass(int i) {
        Class typeClass = null;
        switch (this.fields[i].fieldType) {
            case 'C': {
                typeClass = String.class;
                break;
            }
            case 'N': {
                if (this.fields[i].decimalCount == 0) {
                    if (this.fields[i].fieldLength < 10) {
                        typeClass = Integer.class;
                        break;
                    }
                    typeClass = Long.class;
                    break;
                }
                typeClass = Double.class;
                break;
            }
            case 'F': {
                typeClass = Double.class;
                break;
            }
            case 'L': {
                typeClass = Boolean.class;
                break;
            }
            case 'D': {
                typeClass = Date.class;
                break;
            }
            case '@': {
                typeClass = Timestamp.class;
                break;
            }
            default: {
                typeClass = String.class;
            }
        }
        return typeClass;
    }

    public int getFieldLength(int inIndex) {
        return this.fields[inIndex].fieldLength;
    }

    public String getFieldName(int inIndex) {
        return this.fields[inIndex].fieldName;
    }

    public char getFieldType(int inIndex) {
        return this.fields[inIndex].fieldType;
    }

    public Date getLastUpdateDate() {
        return this.date;
    }

    public int getNumFields() {
        return this.fields.length;
    }

    public int getNumRecords() {
        return this.recordCnt;
    }

    public int getRecordLength() {
        return this.recordLength;
    }

    public int getHeaderLength() {
        return this.headerLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readHeader(ReadableByteChannel channel, Charset charset) throws IOException {
        ByteBuffer in = NIOUtilities.allocate(1024);
        try {
            in.order(ByteOrder.LITTLE_ENDIAN);
            in.limit(10);
            this.read(in, channel);
            in.position(0);
            byte magic = in.get();
            if (magic != 3) {
                throw new IOException("Unsupported DBF file Type " + Integer.toHexString(magic));
            }
            int tempUpdateYear = in.get();
            byte tempUpdateMonth = in.get();
            byte tempUpdateDay = in.get();
            tempUpdateYear = tempUpdateYear > 90 ? (tempUpdateYear += 1900) : (tempUpdateYear += 2000);
            Calendar c = Calendar.getInstance();
            c.set(1, tempUpdateYear);
            c.set(2, tempUpdateMonth - 1);
            c.set(5, tempUpdateDay);
            this.date = c.getTime();
            this.recordCnt = in.getInt();
            this.headerLength = in.get() & 0xFF | (in.get() & 0xFF) << 8;
            if (this.headerLength > in.capacity()) {
                NIOUtilities.clean(in, false);
                in = NIOUtilities.allocate(this.headerLength - 10);
            }
            in.limit(this.headerLength - 10);
            in.position(0);
            this.read(in, channel);
            in.position(0);
            this.recordLength = in.get() & 0xFF | (in.get() & 0xFF) << 8;
            in.position(in.position() + 20);
            this.fieldCnt = (this.headerLength - 32 - 1) / 32;
            ArrayList<DbaseField> lfields = new ArrayList<DbaseField>();
            for (int i = 0; i < this.fieldCnt; ++i) {
                DbaseField field = new DbaseField();
                byte[] buffer = new byte[11];
                in.get(buffer);
                String name = new String(buffer, charset.name());
                int nullPoint = name.indexOf(0);
                if (nullPoint != -1) {
                    name = name.substring(0, nullPoint);
                }
                field.fieldName = name.trim();
                field.fieldType = (char)in.get();
                field.fieldDataAddress = in.getInt();
                int length = in.get();
                if (length < 0) {
                    length += 256;
                }
                field.fieldLength = length;
                if (length > this.largestFieldSize) {
                    this.largestFieldSize = length;
                }
                field.decimalCount = in.get();
                in.position(in.position() + 14);
                if (field.fieldLength <= 0) continue;
                lfields.add(field);
            }
            in.position(in.position() + 1);
            this.fields = new DbaseField[lfields.size()];
            this.fields = lfields.toArray(this.fields);
        }
        finally {
            NIOUtilities.clean(in, false);
        }
    }

    public void readHeader(ByteBuffer in) throws IOException {
        in.order(ByteOrder.LITTLE_ENDIAN);
        byte magic = in.get();
        if (magic != 3) {
            throw new IOException("Unsupported DBF file Type " + Integer.toHexString(magic));
        }
        int tempUpdateYear = in.get();
        byte tempUpdateMonth = in.get();
        byte tempUpdateDay = in.get();
        tempUpdateYear = tempUpdateYear > 90 ? (tempUpdateYear += 1900) : (tempUpdateYear += 2000);
        Calendar c = Calendar.getInstance();
        c.set(1, tempUpdateYear);
        c.set(2, tempUpdateMonth - 1);
        c.set(5, tempUpdateDay);
        this.date = c.getTime();
        this.recordCnt = in.getInt();
        this.headerLength = in.get() & 0xFF | (in.get() & 0xFF) << 8;
        if (this.headerLength > in.capacity()) {
            throw new IllegalArgumentException("The contract says the buffer should be long enough to fit all the header!");
        }
        this.recordLength = in.get() & 0xFF | (in.get() & 0xFF) << 8;
        in.position(in.position() + 20);
        this.fieldCnt = (this.headerLength - 32 - 1) / 32;
        ArrayList<DbaseField> lfields = new ArrayList<DbaseField>();
        for (int i = 0; i < this.fieldCnt; ++i) {
            DbaseField field = new DbaseField();
            byte[] buffer = new byte[11];
            in.get(buffer);
            String name = new String(buffer);
            int nullPoint = name.indexOf(0);
            if (nullPoint != -1) {
                name = name.substring(0, nullPoint);
            }
            field.fieldName = name.trim();
            field.fieldType = (char)in.get();
            field.fieldDataAddress = in.getInt();
            int length = in.get();
            if (length < 0) {
                length += 256;
            }
            field.fieldLength = length;
            if (length > this.largestFieldSize) {
                this.largestFieldSize = length;
            }
            field.decimalCount = in.get();
            in.position(in.position() + 14);
            if (field.fieldLength <= 0) continue;
            lfields.add(field);
        }
        in.position(in.position() + 1);
        this.fields = new DbaseField[lfields.size()];
        this.fields = lfields.toArray(this.fields);
    }

    public String toString() {
        StringBuffer fs = new StringBuffer();
        for (DbaseField f : this.fields) {
            fs.append(f.fieldName + " " + f.fieldType + " " + f.fieldLength + " " + f.decimalCount + " " + f.fieldDataAddress + "\n");
        }
        return "DB3 Header\nDate : " + this.date + "\n" + "Records : " + this.recordCnt + "\n" + "Fields : " + this.fieldCnt + "\n" + fs;
    }

    class DbaseField {
        String fieldName;
        char fieldType;
        int fieldDataAddress;
        int fieldLength;
        int decimalCount;

        DbaseField() {
        }
    }
}

