/*
 * Decompiled with CFR 0.152.
 */
package javax.measure.unit;

import java.io.Serializable;
import java.util.HashMap;
import javax.measure.converter.ConversionException;
import javax.measure.converter.MultiplyConverter;
import javax.measure.converter.RationalConverter;
import javax.measure.converter.UnitConverter;
import javax.measure.quantity.Dimensionless;
import javax.measure.quantity.Quantity;
import javax.measure.unit.AlternateUnit;
import javax.measure.unit.BaseUnit;
import javax.measure.unit.Dimension;
import javax.measure.unit.ProductUnit;
import javax.measure.unit.TransformedUnit;

public abstract class Unit<Q extends Quantity>
implements Serializable {
    public static final Unit<Dimensionless> ONE = new ProductUnit<Dimensionless>();
    static final HashMap<String, Unit<?>> SYMBOL_TO_UNIT = new HashMap();

    protected Unit() {
    }

    public abstract Unit<? super Q> getStandardUnit();

    public abstract UnitConverter toStandardUnit();

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    public boolean isStandardUnit() {
        return this.getStandardUnit().equals(this);
    }

    public final boolean isCompatible(Unit<?> unit) {
        return this == unit || this.getStandardUnit().equals(unit.getStandardUnit()) || this.getDimension().equals(unit.getDimension());
    }

    public final <T extends Quantity> Unit<T> asType(Class<T> clazz) throws ClassCastException {
        Dimension dimension = this.getDimension();
        Unit unit = null;
        try {
            unit = (Unit)clazz.getField("UNIT").get(null);
        }
        catch (Exception exception) {
            throw new Error(exception);
        }
        Dimension dimension2 = unit.getDimension();
        if (!dimension.equals(dimension2)) {
            throw new ClassCastException();
        }
        return this;
    }

    public final Dimension getDimension() {
        Unit<Q> unit = this.getStandardUnit();
        if (unit instanceof BaseUnit) {
            return Dimension.getModel().getDimension((BaseUnit)unit);
        }
        if (unit instanceof AlternateUnit) {
            return ((AlternateUnit)unit).getParent().getDimension();
        }
        ProductUnit productUnit = (ProductUnit)unit;
        Dimension dimension = Dimension.NONE;
        for (int i = 0; i < productUnit.getUnitCount(); ++i) {
            Unit<Quantity> unit2 = productUnit.getUnit(i);
            Dimension dimension2 = unit2.getDimension().pow(productUnit.getUnitPow(i)).root(productUnit.getUnitRoot(i));
            dimension = dimension.times(dimension2);
        }
        return dimension;
    }

    public final UnitConverter getConverterTo(Unit<?> unit) throws ConversionException {
        Unit<?> unit2;
        if (this.equals(unit)) {
            return UnitConverter.IDENTITY;
        }
        Unit<Q> unit3 = this.getStandardUnit();
        if (unit3.equals(unit2 = unit.getStandardUnit())) {
            return unit.toStandardUnit().inverse().concatenate(this.toStandardUnit());
        }
        if (!unit3.getDimension().equals(unit2.getDimension())) {
            throw new ConversionException(this + " is not compatible with " + unit);
        }
        UnitConverter unitConverter = this.toStandardUnit().concatenate(Unit.transformOf(this.getBaseUnits()));
        UnitConverter unitConverter2 = unit.toStandardUnit().concatenate(Unit.transformOf(super.getBaseUnits()));
        return unitConverter2.inverse().concatenate(unitConverter);
    }

    private Unit<?> getBaseUnits() {
        Unit<Q> unit = this.getStandardUnit();
        if (unit instanceof BaseUnit) {
            return unit;
        }
        if (unit instanceof AlternateUnit) {
            return super.getBaseUnits();
        }
        if (unit instanceof ProductUnit) {
            ProductUnit productUnit = (ProductUnit)unit;
            Unit<Quantity> unit2 = ONE;
            for (int i = 0; i < productUnit.getUnitCount(); ++i) {
                Unit<Object> unit3 = super.getBaseUnits();
                unit3 = unit3.pow(productUnit.getUnitPow(i));
                unit3 = unit3.root(productUnit.getUnitRoot(i));
                unit2 = unit2.times(unit3);
            }
            return unit2;
        }
        throw new InternalError("System Unit cannot be an instance of " + this.getClass());
    }

    private static UnitConverter transformOf(Unit<?> unit) {
        if (unit instanceof BaseUnit) {
            return Dimension.getModel().getTransform((BaseUnit)unit);
        }
        ProductUnit productUnit = (ProductUnit)unit;
        UnitConverter unitConverter = UnitConverter.IDENTITY;
        for (int i = 0; i < productUnit.getUnitCount(); ++i) {
            Unit<Quantity> unit2 = productUnit.getUnit(i);
            UnitConverter unitConverter2 = Unit.transformOf(unit2);
            if (!unitConverter2.isLinear()) {
                throw new ConversionException(unit + " is non-linear, cannot convert");
            }
            if (productUnit.getUnitRoot(i) != 1) {
                throw new ConversionException(productUnit + " holds a base unit with fractional exponent");
            }
            int n = productUnit.getUnitPow(i);
            if (n < 0) {
                n = -n;
                unitConverter2 = unitConverter2.inverse();
            }
            for (int j = 0; j < n; ++j) {
                unitConverter = unitConverter.concatenate(unitConverter2);
            }
        }
        return unitConverter;
    }

    public final Unit<Q> transform(UnitConverter unitConverter) {
        if (this instanceof TransformedUnit) {
            TransformedUnit transformedUnit = (TransformedUnit)this;
            Unit unit = transformedUnit.getParentUnit();
            UnitConverter unitConverter2 = transformedUnit.toParentUnit().concatenate(unitConverter);
            if (unitConverter2 == UnitConverter.IDENTITY) {
                return unit;
            }
            return new TransformedUnit(unit, unitConverter2);
        }
        if (unitConverter == UnitConverter.IDENTITY) {
            return this;
        }
        return new TransformedUnit(this, unitConverter);
    }

    public final Unit<Q> times(long l) {
        return this.transform(new RationalConverter(l, 1L));
    }

    public final Unit<Q> times(double d) {
        return this.transform(new MultiplyConverter(d));
    }

    public final Unit<? extends Quantity> times(Unit<?> unit) {
        return ProductUnit.getProductInstance(this, unit);
    }

    public final Unit<? extends Quantity> inverse() {
        return ProductUnit.getQuotientInstance(ONE, this);
    }

    public final Unit<Q> divide(long l) {
        return this.transform(new RationalConverter(1L, l));
    }

    public final Unit<? extends Quantity> divide(Unit<?> unit) {
        return this.times(unit.inverse());
    }

    public final Unit<? extends Quantity> root(int n) {
        if (n > 0) {
            return ProductUnit.getRootInstance(this, n);
        }
        if (n == 0) {
            throw new ArithmeticException("Root's order of zero");
        }
        return ONE.divide(this.root(-n));
    }

    public final Unit<? extends Quantity> pow(int n) {
        if (n > 0) {
            return this.times(this.pow(n - 1));
        }
        if (n == 0) {
            return ONE;
        }
        return ONE.divide(this.pow(-n));
    }
}

