/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.valid;

import com.vividsolutions.jts.geom.Coordinate;

public class TopologyValidationError {
    public static final int HOLE_OUTSIDE_SHELL = 2;
    public static final int NESTED_HOLES = 3;
    public static final int DISCONNECTED_INTERIOR = 4;
    public static final int SELF_INTERSECTION = 5;
    public static final int RING_SELF_INTERSECTION = 6;
    public static final int NESTED_SHELLS = 7;
    public static final int DUPLICATE_RINGS = 8;
    public static final int TOO_FEW_POINTS = 9;
    public static final int INVALID_COORDINATE = 10;
    public static final int RING_NOT_CLOSED = 11;
    public static final String[] errMsg = new String[]{"Topology Validation Error", "Repeated Point", "Hole lies outside shell", "Holes are nested", "Interior is disconnected", "Self-intersection", "Ring Self-intersection", "Nested shells", "Duplicate Rings", "Too few distinct points in geometry component", "Invalid Coordinate", "Ring is not closed"};
    private int errorType;
    private Coordinate pt;

    public TopologyValidationError(int n, Coordinate coordinate) {
        this.errorType = n;
        if (coordinate != null) {
            this.pt = (Coordinate)coordinate.clone();
        }
    }

    public String getMessage() {
        return errMsg[this.errorType];
    }

    public String toString() {
        String string = "";
        if (this.pt != null) {
            string = " at or near point " + this.pt;
        }
        return this.getMessage() + string;
    }
}

