/*
 * Decompiled with CFR 0.152.
 */
package org.jdom;

import org.jdom.Content;
import org.jdom.IllegalDataException;
import org.jdom.Verifier;

public class Text
extends Content {
    static final String EMPTY_STRING = "";
    protected String value;

    protected Text() {
    }

    public Text(String string) {
        this.setText(string);
    }

    public String getText() {
        return this.value;
    }

    public Text setText(String string) {
        if (string == null) {
            this.value = EMPTY_STRING;
            return this;
        }
        String string2 = Verifier.checkCharacterData(string);
        if (string2 != null) {
            throw new IllegalDataException(string, "character content", string2);
        }
        this.value = string;
        return this;
    }

    public void append(String string) {
        if (string == null) {
            return;
        }
        String string2 = Verifier.checkCharacterData(string);
        if (string2 != null) {
            throw new IllegalDataException(string, "character content", string2);
        }
        if (string.length() > 0) {
            this.value = this.value + string;
        }
    }

    public void append(Text text) {
        if (text == null) {
            return;
        }
        this.value = this.value + text.getText();
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return new StringBuffer(64).append("[Text: ").append(this.getText()).append("]").toString();
    }

    @Override
    public Object clone() {
        Text text = (Text)super.clone();
        text.value = this.value;
        return text;
    }
}

