/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry;

import java.io.Serializable;
import java.util.Arrays;
import org.geotools.geometry.AbstractDirectPosition;
import org.geotools.geometry.AbstractEnvelope;
import org.geotools.geometry.GeneralDirectPosition;
import org.geotools.referencing.CRS;
import org.geotools.resources.i18n.Errors;
import org.geotools.util.Utilities;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.geometry.MismatchedReferenceSystemException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.util.Cloneable;

public class GeneralEnvelope
extends AbstractEnvelope
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1752330560227688940L;
    private double[] ordinates;
    private CoordinateReferenceSystem crs;

    public GeneralEnvelope(double[] minDP, double[] maxDP) throws IllegalArgumentException {
        GeneralEnvelope.ensureNonNull("minDP", minDP);
        GeneralEnvelope.ensureNonNull("maxDP", maxDP);
        GeneralEnvelope.ensureSameDimension(minDP.length, maxDP.length);
        this.ordinates = new double[minDP.length + maxDP.length];
        System.arraycopy(minDP, 0, this.ordinates, 0, minDP.length);
        System.arraycopy(maxDP, 0, this.ordinates, minDP.length, maxDP.length);
        GeneralEnvelope.checkCoordinates(this.ordinates);
    }

    public GeneralEnvelope(GeneralDirectPosition minDP, GeneralDirectPosition maxDP) throws MismatchedReferenceSystemException, IllegalArgumentException {
        this(minDP.ordinates, maxDP.ordinates);
        this.crs = GeneralEnvelope.getCoordinateReferenceSystem(minDP, maxDP);
        AbstractDirectPosition.checkCoordinateReferenceSystemDimension(this.crs, this.ordinates.length / 2);
    }

    public GeneralEnvelope(Envelope envelope) {
        GeneralEnvelope.ensureNonNull("envelope", envelope);
        if (envelope instanceof GeneralEnvelope) {
            GeneralEnvelope e = (GeneralEnvelope)envelope;
            this.ordinates = (double[])e.ordinates.clone();
            this.crs = e.crs;
        } else {
            this.crs = envelope.getCoordinateReferenceSystem();
            int dimension = envelope.getDimension();
            this.ordinates = new double[2 * dimension];
            for (int i = 0; i < dimension; ++i) {
                this.ordinates[i] = envelope.getMinimum(i);
                this.ordinates[i + dimension] = envelope.getMaximum(i);
            }
            GeneralEnvelope.checkCoordinates(this.ordinates);
        }
    }

    private static void ensureNonNull(String name, Object object) throws IllegalArgumentException {
        if (object == null) {
            throw new IllegalArgumentException(Errors.format(143, name));
        }
    }

    private static void ensureSameDimension(int dim1, int dim2) throws MismatchedDimensionException {
        if (dim1 != dim2) {
            throw new MismatchedDimensionException(Errors.format(93, dim1, dim2));
        }
    }

    private static void checkCoordinates(double[] ordinates) throws IllegalArgumentException {
        if (GeneralEnvelope.isNilCoordinates(ordinates)) {
            return;
        }
        if (GeneralEnvelope.isEmptyOrdinates(ordinates)) {
            return;
        }
        int dimension = ordinates.length / 2;
        for (int i = 0; i < dimension; ++i) {
            if (ordinates[i] <= ordinates[dimension + i]) continue;
            throw new IllegalArgumentException(Errors.format(66, i));
        }
    }

    @Override
    public final CoordinateReferenceSystem getCoordinateReferenceSystem() {
        assert (this.crs == null || this.crs.getCoordinateSystem().getDimension() == this.getDimension());
        return this.crs;
    }

    public void setCoordinateReferenceSystem(CoordinateReferenceSystem crs) throws MismatchedDimensionException {
        AbstractDirectPosition.checkCoordinateReferenceSystemDimension(crs, this.getDimension());
        this.crs = crs;
    }

    @Override
    public final int getDimension() {
        return this.ordinates.length / 2;
    }

    @Override
    public DirectPosition getLowerCorner() {
        int dim = this.ordinates.length / 2;
        GeneralDirectPosition position = new GeneralDirectPosition(dim);
        System.arraycopy(this.ordinates, 0, position.ordinates, 0, dim);
        position.setCoordinateReferenceSystem(this.crs);
        return position;
    }

    @Override
    public DirectPosition getUpperCorner() {
        int dim = this.ordinates.length / 2;
        GeneralDirectPosition position = new GeneralDirectPosition(dim);
        System.arraycopy(this.ordinates, dim, position.ordinates, 0, dim);
        position.setCoordinateReferenceSystem(this.crs);
        return position;
    }

    private static IndexOutOfBoundsException indexOutOfBounds(int dimension) {
        return new IndexOutOfBoundsException(Errors.format(79, dimension));
    }

    @Override
    public final double getMinimum(int dimension) throws IndexOutOfBoundsException {
        if (dimension < this.ordinates.length / 2) {
            return this.ordinates[dimension];
        }
        throw GeneralEnvelope.indexOutOfBounds(dimension);
    }

    @Override
    public final double getMaximum(int dimension) throws IndexOutOfBoundsException {
        if (dimension >= 0) {
            return this.ordinates[dimension + this.ordinates.length / 2];
        }
        throw GeneralEnvelope.indexOutOfBounds(dimension);
    }

    @Override
    @Deprecated
    public final double getCenter(int dimension) {
        return this.getMedian(dimension);
    }

    @Override
    public final double getMedian(int dimension) throws IndexOutOfBoundsException {
        return 0.5 * (this.ordinates[dimension] + this.ordinates[dimension + this.ordinates.length / 2]);
    }

    @Override
    @Deprecated
    public final double getLength(int dimension) {
        return this.getSpan(dimension);
    }

    @Override
    public final double getSpan(int dimension) throws IndexOutOfBoundsException {
        return this.ordinates[dimension + this.ordinates.length / 2] - this.ordinates[dimension];
    }

    public boolean isNull() {
        if (!GeneralEnvelope.isNilCoordinates(this.ordinates)) {
            return false;
        }
        assert (this.isEmpty()) : this;
        return true;
    }

    private static boolean isNilCoordinates(double[] ordinates) throws IllegalArgumentException {
        for (int i = 0; i < ordinates.length; ++i) {
            if (Double.isNaN(ordinates[i])) continue;
            return false;
        }
        return true;
    }

    public boolean isEmpty() {
        if (GeneralEnvelope.isEmptyOrdinates(this.ordinates)) {
            return true;
        }
        assert (!this.isNull()) : this;
        return false;
    }

    private static boolean isEmptyOrdinates(double[] ordinates) {
        int dimension = ordinates.length / 2;
        if (dimension == 0) {
            return true;
        }
        for (int i = 0; i < dimension; ++i) {
            if (ordinates[i] < ordinates[i + dimension]) continue;
            return true;
        }
        return false;
    }

    private static boolean equalsIgnoreMetadata(CoordinateReferenceSystem crs1, CoordinateReferenceSystem crs2) {
        return crs1 == null || crs2 == null || CRS.equalsIgnoreMetadata(crs1, crs2);
    }

    public void add(DirectPosition position) throws MismatchedDimensionException {
        GeneralEnvelope.ensureNonNull("position", position);
        int dim = this.ordinates.length / 2;
        AbstractDirectPosition.ensureDimensionMatch("position", position.getDimension(), dim);
        assert (GeneralEnvelope.equalsIgnoreMetadata(this.crs, position.getCoordinateReferenceSystem())) : position;
        for (int i = 0; i < dim; ++i) {
            double value = position.getOrdinate(i);
            if (value < this.ordinates[i]) {
                this.ordinates[i] = value;
            }
            if (!(value > this.ordinates[i + dim])) continue;
            this.ordinates[i + dim] = value;
        }
        assert (this.isEmpty() || this.contains(position));
    }

    public boolean contains(DirectPosition position) throws MismatchedDimensionException {
        GeneralEnvelope.ensureNonNull("position", position);
        int dim = this.ordinates.length / 2;
        AbstractDirectPosition.ensureDimensionMatch("point", position.getDimension(), dim);
        assert (GeneralEnvelope.equalsIgnoreMetadata(this.crs, position.getCoordinateReferenceSystem())) : position;
        for (int i = 0; i < dim; ++i) {
            double value = position.getOrdinate(i);
            if (!(value >= this.ordinates[i])) {
                return false;
            }
            if (value <= this.ordinates[i + dim]) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int code = Arrays.hashCode(this.ordinates);
        if (this.crs != null) {
            code += this.crs.hashCode();
        }
        assert (code == super.hashCode());
        return code;
    }

    @Override
    public boolean equals(Object object) {
        if (object != null && object.getClass().equals(this.getClass())) {
            GeneralEnvelope that = (GeneralEnvelope)object;
            return Arrays.equals(this.ordinates, that.ordinates) && Utilities.equals(this.crs, that.crs);
        }
        return false;
    }

    @Override
    public GeneralEnvelope clone() {
        try {
            GeneralEnvelope e = (GeneralEnvelope)super.clone();
            e.ordinates = (double[])e.ordinates.clone();
            return e;
        }
        catch (CloneNotSupportedException exception) {
            throw new AssertionError((Object)exception);
        }
    }
}

