/*
 * Decompiled with CFR 0.152.
 */
package javax.measure.unit;

import java.io.Serializable;
import javax.measure.converter.ConversionException;
import javax.measure.converter.UnitConverter;
import javax.measure.quantity.Quantity;
import javax.measure.unit.DerivedUnit;
import javax.measure.unit.Unit;

public final class ProductUnit<Q extends Quantity>
extends DerivedUnit<Q> {
    private final Element[] _elements;
    private int _hashCode;
    private static final long serialVersionUID = 1L;

    ProductUnit() {
        this._elements = new Element[0];
    }

    private ProductUnit(Element[] elementArray) {
        this._elements = elementArray;
    }

    private static Unit<? extends Quantity> getInstance(Element[] elementArray, Element[] elementArray2) {
        int n;
        int n2;
        Unit unit;
        int n3;
        Element[] elementArray3 = new Element[elementArray.length + elementArray2.length];
        int n4 = 0;
        for (n3 = 0; n3 < elementArray.length; ++n3) {
            int n5;
            unit = elementArray[n3]._unit;
            n2 = elementArray[n3]._pow;
            n = elementArray[n3]._root;
            int n6 = 0;
            int n7 = 1;
            for (n5 = 0; n5 < elementArray2.length; ++n5) {
                if (!unit.equals(elementArray2[n5]._unit)) continue;
                n6 = elementArray2[n5]._pow;
                n7 = elementArray2[n5]._root;
                break;
            }
            n5 = n2 * n7 + n6 * n;
            int n8 = n * n7;
            if (n5 == 0) continue;
            int n9 = ProductUnit.gcd(Math.abs(n5), n8);
            elementArray3[n4++] = new Element(unit, n5 / n9, n8 / n9);
        }
        for (n3 = 0; n3 < elementArray2.length; ++n3) {
            unit = elementArray2[n3]._unit;
            n2 = 0;
            for (n = 0; n < elementArray.length; ++n) {
                if (!unit.equals(elementArray[n]._unit)) continue;
                n2 = 1;
                break;
            }
            if (n2 != 0) continue;
            elementArray3[n4++] = elementArray2[n3];
        }
        if (n4 == 0) {
            return ONE;
        }
        if (n4 == 1 && elementArray3[0]._pow == elementArray3[0]._root) {
            return elementArray3[0]._unit;
        }
        Element[] elementArray4 = new Element[n4];
        for (int i = 0; i < n4; ++i) {
            elementArray4[i] = elementArray3[i];
        }
        return new ProductUnit(elementArray4);
    }

    static Unit<? extends Quantity> getProductInstance(Unit<?> unit, Unit<?> unit2) {
        Element[] elementArray = unit instanceof ProductUnit ? ((ProductUnit)unit)._elements : new Element[]{new Element(unit, 1, 1)};
        Element[] elementArray2 = unit2 instanceof ProductUnit ? ((ProductUnit)unit2)._elements : new Element[]{new Element(unit2, 1, 1)};
        return ProductUnit.getInstance(elementArray, elementArray2);
    }

    static Unit<? extends Quantity> getQuotientInstance(Unit<?> unit, Unit<?> unit2) {
        Element[] elementArray;
        Element[] elementArray2 = unit instanceof ProductUnit ? ((ProductUnit)unit)._elements : new Element[]{new Element(unit, 1, 1)};
        if (unit2 instanceof ProductUnit) {
            Element[] elementArray3 = ((ProductUnit)unit2)._elements;
            elementArray = new Element[elementArray3.length];
            for (int i = 0; i < elementArray3.length; ++i) {
                elementArray[i] = new Element(elementArray3[i]._unit, -elementArray3[i]._pow, elementArray3[i]._root);
            }
        } else {
            elementArray = new Element[]{new Element(unit2, -1, 1)};
        }
        return ProductUnit.getInstance(elementArray2, elementArray);
    }

    static Unit<? extends Quantity> getRootInstance(Unit<?> unit, int n) {
        Element[] elementArray;
        if (unit instanceof ProductUnit) {
            Element[] elementArray2 = ((ProductUnit)unit)._elements;
            elementArray = new Element[elementArray2.length];
            for (int i = 0; i < elementArray2.length; ++i) {
                int n2 = ProductUnit.gcd(Math.abs(elementArray2[i]._pow), elementArray2[i]._root * n);
                elementArray[i] = new Element(elementArray2[i]._unit, elementArray2[i]._pow / n2, elementArray2[i]._root * n / n2);
            }
        } else {
            elementArray = new Element[]{new Element(unit, 1, n)};
        }
        return ProductUnit.getInstance(elementArray, new Element[0]);
    }

    public int getUnitCount() {
        return this._elements.length;
    }

    public Unit<? extends Quantity> getUnit(int n) {
        return this._elements[n].getUnit();
    }

    public int getUnitPow(int n) {
        return this._elements[n].getPow();
    }

    public int getUnitRoot(int n) {
        return this._elements[n].getRoot();
    }

    @Override
    public boolean equals(Object object) {
        Element[] elementArray;
        if (this == object) {
            return true;
        }
        if (object instanceof ProductUnit && this._elements.length == (elementArray = ((ProductUnit)object)._elements).length) {
            for (int i = 0; i < this._elements.length; ++i) {
                boolean bl = false;
                for (int j = 0; j < elementArray.length; ++j) {
                    if (!this._elements[i]._unit.equals(elementArray[j]._unit)) continue;
                    if (this._elements[i]._pow != elementArray[j]._pow || this._elements[i]._root != elementArray[j]._root) {
                        return false;
                    }
                    bl = true;
                    break;
                }
                if (bl) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        if (this._hashCode != 0) {
            return this._hashCode;
        }
        int n = 0;
        for (int i = 0; i < this._elements.length; ++i) {
            n += this._elements[i]._unit.hashCode() * (this._elements[i]._pow * 3 - this._elements[i]._root * 2);
        }
        this._hashCode = n;
        return n;
    }

    @Override
    public Unit<? super Q> getStandardUnit() {
        if (this.hasOnlyStandardUnit()) {
            return this;
        }
        Unit<Quantity> unit = ONE;
        for (int i = 0; i < this._elements.length; ++i) {
            Unit<Object> unit2 = this._elements[i]._unit.getStandardUnit();
            unit2 = unit2.pow(this._elements[i]._pow);
            unit2 = unit2.root(this._elements[i]._root);
            unit = unit.times(unit2);
        }
        return unit;
    }

    @Override
    public UnitConverter toStandardUnit() {
        if (this.hasOnlyStandardUnit()) {
            return UnitConverter.IDENTITY;
        }
        UnitConverter unitConverter = UnitConverter.IDENTITY;
        for (int i = 0; i < this._elements.length; ++i) {
            UnitConverter unitConverter2 = this._elements[i]._unit.toStandardUnit();
            if (!unitConverter2.isLinear()) {
                throw new ConversionException(this._elements[i]._unit + " is non-linear, cannot convert");
            }
            if (this._elements[i]._root != 1) {
                throw new ConversionException(this._elements[i]._unit + " holds a base unit with fractional exponent");
            }
            int n = this._elements[i]._pow;
            if (n < 0) {
                n = -n;
                unitConverter2 = unitConverter2.inverse();
            }
            for (int j = 0; j < n; ++j) {
                unitConverter = unitConverter.concatenate(unitConverter2);
            }
        }
        return unitConverter;
    }

    private boolean hasOnlyStandardUnit() {
        for (int i = 0; i < this._elements.length; ++i) {
            Unit unit = this._elements[i]._unit;
            if (unit.isStandardUnit()) continue;
            return false;
        }
        return true;
    }

    private static int gcd(int n, int n2) {
        if (n2 == 0) {
            return n;
        }
        return ProductUnit.gcd(n2, n % n2);
    }

    private static final class Element
    implements Serializable {
        private final Unit<?> _unit;
        private final int _pow;
        private final int _root;
        private static final long serialVersionUID = 1L;

        private Element(Unit<?> unit, int n, int n2) {
            this._unit = unit;
            this._pow = n;
            this._root = n2;
        }

        public Unit<?> getUnit() {
            return this._unit;
        }

        public int getPow() {
            return this._pow;
        }

        public int getRoot() {
            return this._root;
        }
    }
}

