/*
 * Decompiled with CFR 0.152.
 */
package mirrored_download;

import java.io.InputStream;
import mirrored_download.MirroredDownloadPlugin;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.DataSource;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.BoundingBoxDownloader;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.OsmTransferException;

public class BoundingBoxDownloader2
extends BoundingBoxDownloader {
    private final double lat1;
    private final double lon1;
    private final double lat2;
    private final double lon2;
    private final boolean crosses180th;

    public BoundingBoxDownloader2(Bounds downloadArea) {
        super(downloadArea);
        this.lat1 = downloadArea.getMin().lat();
        this.lon1 = downloadArea.getMin().lon();
        this.lat2 = downloadArea.getMax().lat();
        this.lon2 = downloadArea.getMax().lon();
        this.crosses180th = downloadArea.crosses180thMeridian();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InputStream getInputStream(String urlStr, ProgressMonitor progressMonitor) throws OsmTransferException {
        try {
            OsmApi.getOsmApi().initialize(progressMonitor);
            urlStr = MirroredDownloadPlugin.getDownloadUrl() + urlStr;
            InputStream inputStream = this.getInputStreamRaw(urlStr, progressMonitor);
            return inputStream;
        }
        finally {
            progressMonitor.invalidate();
        }
    }

    public DataSet parseOsm(ProgressMonitor progressMonitor) throws OsmTransferException {
        DataSet ds = super.parseOsm(progressMonitor);
        System.out.println(ds.dataSources.toString());
        if (ds != null && ds.dataSources.size() == 0) {
            if (this.crosses180th) {
                Bounds bounds = new Bounds(this.lat1, this.lon1, this.lat2, 180.0);
                DataSource src = new DataSource(bounds, MirroredDownloadPlugin.getDownloadUrl());
                ds.dataSources.add(src);
                bounds = new Bounds(this.lat1, -180.0, this.lat2, this.lon2);
                src = new DataSource(bounds, MirroredDownloadPlugin.getDownloadUrl());
                ds.dataSources.add(src);
            } else {
                Bounds bounds = new Bounds(this.lat1, this.lon1, this.lat2, this.lon2);
                DataSource src = new DataSource(bounds, MirroredDownloadPlugin.getDownloadUrl());
                ds.dataSources.add(src);
            }
        }
        System.out.println(ds.dataSources.toString());
        return ds;
    }
}

