/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.core.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.openstreetmap.josm.gui.widgets.HtmlPanel;
import org.openstreetmap.josm.gui.widgets.VerticallyScrollablePanel;
import org.openstreetmap.josm.plugins.opendata.core.gui.ModulePreferencesModel;
import org.openstreetmap.josm.plugins.opendata.core.modules.ModuleInformation;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.OpenBrowser;

public class ModuleListPanel
extends VerticallyScrollablePanel {
    private ModulePreferencesModel model;

    public ModuleListPanel() {
        this.model = new ModulePreferencesModel();
        this.setLayout(new GridBagLayout());
    }

    public ModuleListPanel(ModulePreferencesModel model) {
        this.model = model;
        this.setLayout(new GridBagLayout());
    }

    protected String formatModuleRemoteVersion(ModuleInformation pi) {
        StringBuilder sb = new StringBuilder();
        if (pi.version == null || pi.version.trim().equals("")) {
            sb.append(I18n.tr((String)"unknown", (Object[])new Object[0]));
        } else {
            sb.append(pi.version);
        }
        return sb.toString();
    }

    protected String formatModuleLocalVersion(ModuleInformation pi) {
        if (pi == null) {
            return I18n.tr((String)"unknown", (Object[])new Object[0]);
        }
        if (pi.localversion == null || pi.localversion.trim().equals("")) {
            return I18n.tr((String)"unknown", (Object[])new Object[0]);
        }
        return pi.localversion;
    }

    protected String formatCheckboxTooltipText(ModuleInformation pi) {
        if (pi == null) {
            return "";
        }
        if (pi.downloadlink == null) {
            return I18n.tr((String)"Module bundled with opendata plugin", (Object[])new Object[0]);
        }
        return pi.downloadlink;
    }

    public void displayEmptyModuleListInformation() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.anchor = 10;
        gbc.fill = 1;
        gbc.insets = new Insets(40, 0, 40, 0);
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        HtmlPanel hint = new HtmlPanel();
        hint.setText("<html>" + I18n.tr((String)"Please click on <strong>Download list</strong> to download and display a list of available plugins.", (Object[])new Object[0]) + "</html>");
        this.add((Component)hint, gbc);
    }

    public void refreshView() {
        List<ModuleInformation> displayedModules = this.model.getDisplayedModules();
        this.removeAll();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        if (displayedModules.isEmpty()) {
            this.displayEmptyModuleListInformation();
            return;
        }
        int row = -1;
        for (final ModuleInformation pi : displayedModules) {
            boolean selected = this.model.isSelectedModule(pi.getName());
            String remoteversion = this.formatModuleRemoteVersion(pi);
            String localversion = this.formatModuleLocalVersion(this.model.getModuleInformation(pi.getName()));
            final JCheckBox cbModule = new JCheckBox();
            cbModule.setSelected(selected);
            cbModule.setToolTipText(this.formatCheckboxTooltipText(pi));
            cbModule.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ModuleListPanel.this.model.setModuleSelected(pi.getName(), cbModule.isSelected());
                }
            });
            JLabel lblModule = new JLabel(I18n.tr((String)"{0}: Version {1} (local: {2})", (Object[])new Object[]{pi.getName(), remoteversion, localversion}), pi.getScaledIcon(), 2);
            gbc.gridx = 0;
            gbc.gridy = ++row;
            gbc.insets = new Insets(5, 5, 0, 5);
            gbc.weighty = 0.0;
            gbc.weightx = 0.0;
            this.add(cbModule, gbc);
            gbc.gridx = 1;
            gbc.weightx = 1.0;
            this.add(lblModule, gbc);
            HtmlPanel description = new HtmlPanel();
            description.setText(pi.getDescriptionAsHtml());
            description.getEditorPane().addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        OpenBrowser.displayUrl((String)e.getURL().toString());
                    }
                }
            });
            gbc.gridx = 1;
            gbc.gridy = ++row;
            gbc.insets = new Insets(3, 25, 5, 5);
            gbc.weighty = 1.0;
            this.add((Component)description, gbc);
        }
        this.revalidate();
        this.repaint();
    }
}

