/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing;

import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.geotools.factory.FactoryNotFoundException;
import org.geotools.factory.FactoryRegistryException;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.metadata.iso.extent.GeographicBoundingBoxImpl;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.DefaultAuthorityFactory;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.factory.AbstractAuthorityFactory;
import org.geotools.referencing.factory.IdentifiedObjectFinder;
import org.geotools.referencing.operation.transform.IdentityTransform;
import org.geotools.resources.CRSUtilities;
import org.geotools.resources.i18n.Errors;
import org.geotools.util.logging.Logging;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.metadata.extent.GeographicExtent;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.MathTransform;

public final class CRS {
    static final Logger LOGGER = Logging.getLogger(CRS.class);
    private static final Hints FORCE_LONGITUDE_FIRST_AXIS_ORDER = new Hints(Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER, Boolean.TRUE);
    private static CRSAuthorityFactory defaultFactory;
    private static CRSAuthorityFactory xyFactory;
    private static CoordinateOperationFactory strictFactory;
    private static CoordinateOperationFactory lenientFactory;

    private CRS() {
    }

    public static synchronized CRSAuthorityFactory getAuthorityFactory(boolean longitudeFirst) throws FactoryRegistryException {
        CRSAuthorityFactory factory;
        CRSAuthorityFactory cRSAuthorityFactory = factory = longitudeFirst ? xyFactory : defaultFactory;
        if (factory == null) {
            try {
                factory = new DefaultAuthorityFactory(longitudeFirst);
                if (longitudeFirst) {
                    xyFactory = factory;
                } else {
                    defaultFactory = factory;
                }
            }
            catch (NoSuchElementException exception) {
                throw new FactoryNotFoundException(null, exception);
            }
        }
        return factory;
    }

    public static synchronized CoordinateOperationFactory getCoordinateOperationFactory(boolean lenient) {
        CoordinateOperationFactory factory;
        CoordinateOperationFactory coordinateOperationFactory = factory = lenient ? lenientFactory : strictFactory;
        if (factory == null) {
            Hints hints = GeoTools.getDefaultHints();
            if (lenient) {
                hints.put(Hints.LENIENT_DATUM_SHIFT, Boolean.TRUE);
            }
            factory = ReferencingFactoryFinder.getCoordinateOperationFactory(hints);
            if (lenient) {
                lenientFactory = factory;
            } else {
                strictFactory = factory;
            }
        }
        return factory;
    }

    public static CoordinateReferenceSystem decode(String code) throws NoSuchAuthorityCodeException, FactoryException {
        return CRS.decode(code, false);
    }

    public static CoordinateReferenceSystem decode(String code, boolean longitudeFirst) throws NoSuchAuthorityCodeException, FactoryException {
        code = code.trim().toUpperCase();
        return CRS.getAuthorityFactory(longitudeFirst).createCoordinateReferenceSystem(code);
    }

    public static CoordinateReferenceSystem parseWKT(String wkt) throws FactoryException {
        return ReferencingFactoryFinder.getCRSFactory(null).createFromWKT(wkt);
    }

    public static GeographicBoundingBox getGeographicBoundingBox(CoordinateReferenceSystem crs) {
        Extent domainOfValidity;
        GeographicBoundingBox bounds = null;
        GeographicBoundingBoxImpl merged = null;
        if (crs != null && (domainOfValidity = crs.getDomainOfValidity()) != null) {
            for (GeographicExtent geographicExtent : domainOfValidity.getGeographicElements()) {
                if (!(geographicExtent instanceof GeographicBoundingBox)) continue;
                GeographicBoundingBox candidate = (GeographicBoundingBox)geographicExtent;
                if (bounds == null) {
                    bounds = candidate;
                    continue;
                }
                if (merged == null) {
                    merged = new GeographicBoundingBoxImpl(bounds);
                    bounds = merged;
                }
                merged.add(candidate);
            }
        }
        return bounds;
    }

    public static Ellipsoid getEllipsoid(CoordinateReferenceSystem crs) {
        Datum datum = CRSUtilities.getDatum(crs);
        if (datum instanceof GeodeticDatum) {
            return ((GeodeticDatum)datum).getEllipsoid();
        }
        if (crs instanceof CompoundCRS) {
            CompoundCRS cp = (CompoundCRS)crs;
            for (CoordinateReferenceSystem c : cp.getCoordinateReferenceSystems()) {
                Ellipsoid candidate = CRS.getEllipsoid(c);
                if (candidate == null) continue;
                return candidate;
            }
        }
        return null;
    }

    public static boolean equalsIgnoreMetadata(Object object1, Object object2) {
        if (object1 == object2) {
            return true;
        }
        if (object1 instanceof AbstractIdentifiedObject && object2 instanceof AbstractIdentifiedObject) {
            return ((AbstractIdentifiedObject)object1).equals((AbstractIdentifiedObject)object2, false);
        }
        return object1 != null && object1.equals(object2);
    }

    public static String toSRS(CoordinateReferenceSystem crs) {
        boolean forcedLonLat = false;
        try {
            forcedLonLat = Boolean.getBoolean("org.geotools.referencing.forceXY") || Boolean.TRUE.equals(Hints.getSystemDefault(Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER));
        }
        catch (Exception e) {
            LOGGER.log(Level.FINE, "Failed to determine if we are in forced lon/lat mode", e);
        }
        if (forcedLonLat && CRS.getAxisOrder(crs, false) == AxisOrder.NORTH_EAST) {
            try {
                Integer code = CRS.lookupEpsgCode(crs, false);
                if (code != null) {
                    return "urn:ogc:def:crs:EPSG::" + code;
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.FINE, "Failed to determine EPSG code", e);
            }
        }
        if (crs == null) {
            return null;
        }
        Set<ReferenceIdentifier> identifiers = crs.getIdentifiers();
        if (identifiers.isEmpty()) {
            ReferenceIdentifier name = crs.getName();
            if (name != null) {
                return name.toString();
            }
        } else {
            return identifiers.iterator().next().toString();
        }
        return null;
    }

    public static String lookupIdentifier(Citation authority, CoordinateReferenceSystem crs, boolean fullScan) throws FactoryException {
        ReferenceIdentifier id = AbstractIdentifiedObject.getIdentifier(crs, authority);
        if (id != null) {
            return id.getCode();
        }
        for (CRSAuthorityFactory factory : ReferencingFactoryFinder.getCRSAuthorityFactories(FORCE_LONGITUDE_FIRST_AXIS_ORDER)) {
            if (!Citations.identifierMatches(factory.getAuthority(), authority) || !(factory instanceof AbstractAuthorityFactory)) continue;
            AbstractAuthorityFactory f = (AbstractAuthorityFactory)((Object)factory);
            IdentifiedObjectFinder finder = f.getIdentifiedObjectFinder(crs.getClass());
            finder.setFullScanAllowed(fullScan);
            String code = finder.findIdentifier(crs);
            if (code == null) continue;
            return code;
        }
        return null;
    }

    public static Integer lookupEpsgCode(CoordinateReferenceSystem crs, boolean fullScan) throws FactoryException {
        String identifier = CRS.lookupIdentifier(Citations.EPSG, crs, fullScan);
        if (identifier != null) {
            int split = identifier.lastIndexOf(58);
            String code = identifier.substring(split + 1);
            try {
                return Integer.parseInt(code);
            }
            catch (NumberFormatException e) {
                throw new FactoryException(Errors.format(67, identifier), e);
            }
        }
        return null;
    }

    public static MathTransform findMathTransform(CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS) throws FactoryException {
        return CRS.findMathTransform(sourceCRS, targetCRS, false);
    }

    public static MathTransform findMathTransform(CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, boolean lenient) throws FactoryException {
        if (CRS.equalsIgnoreMetadata(sourceCRS, targetCRS)) {
            return IdentityTransform.create(sourceCRS.getCoordinateSystem().getDimension());
        }
        CoordinateOperationFactory operationFactory = CRS.getCoordinateOperationFactory(lenient);
        return operationFactory.createOperation(sourceCRS, targetCRS).getMathTransform();
    }

    public static AxisOrder getAxisOrder(CoordinateReferenceSystem crs, boolean useBaseGeoCRS) {
        CoordinateSystem cs = null;
        if (crs instanceof ProjectedCRS) {
            cs = !useBaseGeoCRS ? crs.getCoordinateSystem() : ((ProjectedCRS)crs).getBaseCRS().getCoordinateSystem();
        } else if (crs instanceof GeographicCRS) {
            cs = crs.getCoordinateSystem();
        } else {
            return AxisOrder.INAPPLICABLE;
        }
        int dimension = cs.getDimension();
        int longitudeDim = -1;
        int latitudeDim = -1;
        for (int i = 0; i < dimension; ++i) {
            AxisDirection dir = cs.getAxis(i).getDirection().absolute();
            if (dir.equals(AxisDirection.EAST)) {
                longitudeDim = i;
            }
            if (!dir.equals(AxisDirection.NORTH)) continue;
            latitudeDim = i;
        }
        if (longitudeDim >= 0 && latitudeDim >= 0) {
            if (longitudeDim < latitudeDim) {
                return AxisOrder.EAST_NORTH;
            }
            return AxisOrder.NORTH_EAST;
        }
        return AxisOrder.INAPPLICABLE;
    }

    static {
        GeoTools.addChangeListener(new ChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stateChanged(ChangeEvent e) {
                Class<CRS> clazz = CRS.class;
                synchronized (CRS.class) {
                    defaultFactory = null;
                    xyFactory = null;
                    strictFactory = null;
                    lenientFactory = null;
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            }
        });
    }

    public static enum AxisOrder {
        EAST_NORTH,
        NORTH_EAST,
        INAPPLICABLE;

    }
}

