/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.expression;

import com.vividsolutions.jts.geom.Geometry;
import java.util.regex.Pattern;
import org.geotools.factory.Hints;
import org.geotools.filter.expression.PropertyAccessor;
import org.geotools.filter.expression.PropertyAccessorFactory;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;

public class SimpleFeaturePropertyAccessorFactory
implements PropertyAccessorFactory {
    static PropertyAccessor ATTRIBUTE_ACCESS = new SimpleFeaturePropertyAccessor();
    static PropertyAccessor DEFAULT_GEOMETRY_ACCESS = new DefaultGeometrySimpleFeaturePropertyAccessor();
    static PropertyAccessor FID_ACCESS = new FidSimpleFeaturePropertyAccessor();
    static Pattern idPattern = Pattern.compile("@(\\w+:)?id");
    static Pattern propertyPattern = Pattern.compile("(\\w+:)?(\\w+)");

    @Override
    public PropertyAccessor createPropertyAccessor(Class type, String xpath, Class target, Hints hints) {
        if (xpath == null) {
            return null;
        }
        if (!SimpleFeature.class.isAssignableFrom(type) && !SimpleFeatureType.class.isAssignableFrom(type)) {
            return null;
        }
        if ("".equals(xpath)) {
            return DEFAULT_GEOMETRY_ACCESS;
        }
        if (idPattern.matcher(xpath).matches()) {
            return FID_ACCESS;
        }
        if (propertyPattern.matcher(xpath).matches()) {
            return ATTRIBUTE_ACCESS;
        }
        return null;
    }

    static String stripPrefix(String xpath) {
        int split = xpath.indexOf(":");
        if (split != -1) {
            return xpath.substring(split + 1);
        }
        return xpath;
    }

    static class SimpleFeaturePropertyAccessor
    implements PropertyAccessor {
        SimpleFeaturePropertyAccessor() {
        }

        @Override
        public boolean canHandle(Object object, String xpath, Class target) {
            xpath = SimpleFeaturePropertyAccessorFactory.stripPrefix(xpath);
            if (object instanceof SimpleFeature) {
                return ((SimpleFeature)object).getType().getDescriptor(xpath) != null;
            }
            if (object instanceof SimpleFeatureType) {
                return ((SimpleFeatureType)object).getDescriptor(xpath) != null;
            }
            return false;
        }

        @Override
        public Object get(Object object, String xpath, Class target) {
            xpath = SimpleFeaturePropertyAccessorFactory.stripPrefix(xpath);
            if (object instanceof SimpleFeature) {
                return ((SimpleFeature)object).getAttribute(xpath);
            }
            if (object instanceof SimpleFeatureType) {
                return ((SimpleFeatureType)object).getDescriptor(xpath);
            }
            return null;
        }
    }

    static class DefaultGeometrySimpleFeaturePropertyAccessor
    implements PropertyAccessor {
        DefaultGeometrySimpleFeaturePropertyAccessor() {
        }

        @Override
        public boolean canHandle(Object object, String xpath, Class target) {
            if (!"".equals(xpath)) {
                return false;
            }
            return object instanceof SimpleFeature || object instanceof SimpleFeatureType;
        }

        @Override
        public Object get(Object object, String xpath, Class target) {
            if (object instanceof SimpleFeature) {
                SimpleFeature f = (SimpleFeature)object;
                Object defaultGeometry = f.getDefaultGeometry();
                if (defaultGeometry == null) {
                    for (Object o : f.getAttributes()) {
                        if (!(o instanceof Geometry)) continue;
                        defaultGeometry = o;
                        break;
                    }
                }
                return defaultGeometry;
            }
            if (object instanceof SimpleFeatureType) {
                SimpleFeatureType ft = (SimpleFeatureType)object;
                GeometryDescriptor gd = ft.getGeometryDescriptor();
                if (gd == null) {
                    for (AttributeDescriptor ad : ft.getAttributeDescriptors()) {
                        if (!Geometry.class.isAssignableFrom(ad.getType().getBinding())) continue;
                        return ad;
                    }
                }
                return gd;
            }
            return null;
        }
    }

    static class FidSimpleFeaturePropertyAccessor
    implements PropertyAccessor {
        FidSimpleFeaturePropertyAccessor() {
        }

        @Override
        public boolean canHandle(Object object, String xpath, Class target) {
            return object instanceof SimpleFeature && xpath.matches("@(\\w+:)?id");
        }

        @Override
        public Object get(Object object, String xpath, Class target) {
            SimpleFeature feature = (SimpleFeature)object;
            return feature.getID();
        }
    }
}

