/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.index.bintree;

public class Interval {
    public double min;
    public double max;

    public Interval() {
        this.min = 0.0;
        this.max = 0.0;
    }

    public Interval(double d, double d2) {
        this.init(d, d2);
    }

    public Interval(Interval interval) {
        this.init(interval.min, interval.max);
    }

    public void init(double d, double d2) {
        this.min = d;
        this.max = d2;
        if (d > d2) {
            this.min = d2;
            this.max = d;
        }
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public double getWidth() {
        return this.max - this.min;
    }

    public void expandToInclude(Interval interval) {
        if (interval.max > this.max) {
            this.max = interval.max;
        }
        if (interval.min < this.min) {
            this.min = interval.min;
        }
    }

    public boolean overlaps(Interval interval) {
        return this.overlaps(interval.min, interval.max);
    }

    public boolean overlaps(double d, double d2) {
        return !(this.min > d2) && !(this.max < d);
    }

    public boolean contains(Interval interval) {
        return this.contains(interval.min, interval.max);
    }

    public boolean contains(double d, double d2) {
        return d >= this.min && d2 <= this.max;
    }

    public String toString() {
        return "[" + this.min + ", " + this.max + "]";
    }
}

