/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom.prep;

import com.vividsolutions.jts.algorithm.PointLocator;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.prep.PreparedGeometry;
import com.vividsolutions.jts.geom.util.ComponentCoordinateExtracter;
import java.util.List;

class BasicPreparedGeometry
implements PreparedGeometry {
    private Geometry baseGeom;
    private List representativePts;

    public BasicPreparedGeometry(Geometry geometry) {
        this.baseGeom = geometry;
        this.representativePts = ComponentCoordinateExtracter.getCoordinates(geometry);
    }

    @Override
    public Geometry getGeometry() {
        return this.baseGeom;
    }

    public List getRepresentativePoints() {
        return this.representativePts;
    }

    public boolean isAnyTargetComponentInTest(Geometry geometry) {
        PointLocator pointLocator = new PointLocator();
        for (Coordinate coordinate : this.representativePts) {
            if (!pointLocator.intersects(coordinate, geometry)) continue;
            return true;
        }
        return false;
    }

    protected boolean envelopesIntersect(Geometry geometry) {
        return this.baseGeom.getEnvelopeInternal().intersects(geometry.getEnvelopeInternal());
    }

    protected boolean envelopeCovers(Geometry geometry) {
        return this.baseGeom.getEnvelopeInternal().covers(geometry.getEnvelopeInternal());
    }

    @Override
    public boolean contains(Geometry geometry) {
        return this.baseGeom.contains(geometry);
    }

    public boolean containsProperly(Geometry geometry) {
        if (!this.baseGeom.getEnvelopeInternal().contains(geometry.getEnvelopeInternal())) {
            return false;
        }
        return this.baseGeom.relate(geometry, "T**FF*FF*");
    }

    public boolean covers(Geometry geometry) {
        return this.baseGeom.covers(geometry);
    }

    @Override
    public boolean disjoint(Geometry geometry) {
        return !this.intersects(geometry);
    }

    @Override
    public boolean intersects(Geometry geometry) {
        return this.baseGeom.intersects(geometry);
    }

    public String toString() {
        return this.baseGeom.toString();
    }
}

