/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.crs.AbstractDerivedCRS;
import org.geotools.resources.i18n.Errors;
import org.geotools.util.Utilities;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.quality.PositionalAccuracy;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.ConicProjection;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CylindricalProjection;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Operation;
import org.opengis.referencing.operation.PlanarProjection;
import org.opengis.referencing.operation.Projection;
import org.opengis.referencing.operation.Transformation;
import org.opengis.util.InternationalString;

public class AbstractCoordinateOperation
extends AbstractIdentifiedObject
implements CoordinateOperation {
    private static final long serialVersionUID = 1237358357729193885L;
    public static final PositionalAccuracy[] EMPTY_ACCURACY_ARRAY = new PositionalAccuracy[0];
    private static final String[] LOCALIZABLES = new String[]{"scope"};
    protected final CoordinateReferenceSystem sourceCRS;
    protected final CoordinateReferenceSystem targetCRS;
    final String operationVersion;
    private final Collection<PositionalAccuracy> coordinateOperationAccuracy;
    protected final Extent domainOfValidity;
    private final InternationalString scope;
    protected final MathTransform transform;

    AbstractCoordinateOperation(Conversion definition, CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, MathTransform transform) {
        super(definition);
        this.sourceCRS = sourceCRS;
        this.targetCRS = targetCRS;
        this.operationVersion = definition.getOperationVersion();
        this.coordinateOperationAccuracy = definition.getCoordinateOperationAccuracy();
        this.domainOfValidity = definition.getDomainOfValidity();
        this.scope = definition.getScope();
        this.transform = transform;
    }

    public AbstractCoordinateOperation(Map<String, ?> properties, CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, MathTransform transform) {
        this(properties, new HashMap<String, Object>(), sourceCRS, targetCRS, transform);
    }

    private AbstractCoordinateOperation(Map<String, ?> properties, Map<String, Object> subProperties, CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, MathTransform transform) {
        super(properties, subProperties, LOCALIZABLES);
        this.domainOfValidity = (Extent)subProperties.get("domainOfValidity");
        this.scope = (InternationalString)subProperties.get("scope");
        this.operationVersion = (String)subProperties.get("operationVersion");
        Object[] positionalAccuracy = (PositionalAccuracy[])subProperties.get("coordinateOperationAccuracy");
        if (positionalAccuracy == null || positionalAccuracy.length == 0) {
            positionalAccuracy = null;
        } else {
            positionalAccuracy = (PositionalAccuracy[])positionalAccuracy.clone();
            for (int i = 0; i < positionalAccuracy.length; ++i) {
                AbstractCoordinateOperation.ensureNonNull("coordinateOperationAccuracy", positionalAccuracy, i);
            }
        }
        this.coordinateOperationAccuracy = AbstractCoordinateOperation.asSet(positionalAccuracy);
        this.sourceCRS = sourceCRS;
        this.targetCRS = targetCRS;
        this.transform = transform;
        this.validate();
    }

    void validate() throws IllegalArgumentException {
        AbstractCoordinateOperation.ensureNonNull("sourceCRS", this.transform);
        AbstractCoordinateOperation.ensureNonNull("targetCRS", this.transform);
        AbstractCoordinateOperation.ensureNonNull("transform", this.transform);
        AbstractCoordinateOperation.checkDimension("sourceCRS", this.sourceCRS, this.transform.getSourceDimensions());
        AbstractCoordinateOperation.checkDimension("targetCRS", this.targetCRS, this.transform.getTargetDimensions());
    }

    private static void checkDimension(String name, CoordinateReferenceSystem crs, int expected) {
        int actual = crs.getCoordinateSystem().getDimension();
        if (actual != expected) {
            throw new IllegalArgumentException(Errors.format(94, name, actual, expected));
        }
    }

    @Override
    public CoordinateReferenceSystem getSourceCRS() {
        return this.sourceCRS;
    }

    @Override
    public CoordinateReferenceSystem getTargetCRS() {
        return this.targetCRS;
    }

    @Override
    public String getOperationVersion() {
        return this.operationVersion;
    }

    @Override
    public Collection<PositionalAccuracy> getCoordinateOperationAccuracy() {
        if (this.coordinateOperationAccuracy == null) {
            return Collections.emptySet();
        }
        return this.coordinateOperationAccuracy;
    }

    @Override
    public Extent getDomainOfValidity() {
        return this.domainOfValidity;
    }

    @Override
    public InternationalString getScope() {
        return this.scope;
    }

    @Override
    public MathTransform getMathTransform() {
        return this.transform;
    }

    public static Class<? extends CoordinateOperation> getType(CoordinateOperation object) {
        if (object instanceof Transformation) {
            return Transformation.class;
        }
        if (object instanceof ConicProjection) {
            return ConicProjection.class;
        }
        if (object instanceof CylindricalProjection) {
            return CylindricalProjection.class;
        }
        if (object instanceof PlanarProjection) {
            return PlanarProjection.class;
        }
        if (object instanceof Projection) {
            return Projection.class;
        }
        if (object instanceof Conversion) {
            return Conversion.class;
        }
        if (object instanceof Operation) {
            return Operation.class;
        }
        return CoordinateOperation.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(AbstractIdentifiedObject object, boolean compareMetadata) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, compareMetadata)) {
            AbstractCoordinateOperation that = (AbstractCoordinateOperation)object;
            if (AbstractCoordinateOperation.equals(this.sourceCRS, that.sourceCRS, compareMetadata) && Utilities.equals(this.transform, that.transform)) {
                if (!(!compareMetadata || Utilities.equals(this.domainOfValidity, that.domainOfValidity) && Utilities.equals(this.scope, that.scope) && Utilities.equals(this.coordinateOperationAccuracy, that.coordinateOperationAccuracy))) {
                    return false;
                }
                Boolean comparing = AbstractDerivedCRS._COMPARING.get();
                if (comparing != null && comparing.booleanValue()) {
                    return true;
                }
                try {
                    AbstractDerivedCRS._COMPARING.set(Boolean.TRUE);
                    boolean bl = AbstractCoordinateOperation.equals(this.targetCRS, that.targetCRS, compareMetadata);
                    return bl;
                }
                finally {
                    AbstractDerivedCRS._COMPARING.set(Boolean.FALSE);
                }
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        int code = -598790243;
        if (this.sourceCRS != null) {
            code ^= this.sourceCRS.hashCode();
        }
        if (this.targetCRS != null) {
            code ^= this.targetCRS.hashCode();
        }
        if (this.transform != null) {
            code ^= this.transform.hashCode();
        }
        return code;
    }
}

