/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.datum;

import java.util.Collections;
import java.util.Map;
import javax.measure.quantity.Angle;
import javax.measure.unit.NonSI;
import javax.measure.unit.Unit;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.util.Utilities;
import org.opengis.referencing.datum.PrimeMeridian;

public class DefaultPrimeMeridian
extends AbstractIdentifiedObject
implements PrimeMeridian {
    private static final long serialVersionUID = 541978454643213305L;
    public static final DefaultPrimeMeridian GREENWICH = new DefaultPrimeMeridian("Greenwich", 0.0, NonSI.DEGREE_ANGLE);
    private final double greenwichLongitude;
    private final Unit<Angle> angularUnit;

    public DefaultPrimeMeridian(String name, double greenwichLongitude, Unit<Angle> angularUnit) {
        this(Collections.singletonMap("name", name), greenwichLongitude, angularUnit);
    }

    public DefaultPrimeMeridian(Map<String, ?> properties, double greenwichLongitude, Unit<Angle> angularUnit) {
        super(properties);
        this.greenwichLongitude = greenwichLongitude;
        this.angularUnit = angularUnit;
        DefaultPrimeMeridian.ensureAngularUnit(angularUnit);
    }

    @Override
    public double getGreenwichLongitude() {
        return this.greenwichLongitude;
    }

    public double getGreenwichLongitude(Unit<Angle> targetUnit) {
        return this.getAngularUnit().getConverterTo(targetUnit).convert(this.getGreenwichLongitude());
    }

    @Override
    public Unit<Angle> getAngularUnit() {
        return this.angularUnit;
    }

    @Override
    public boolean equals(AbstractIdentifiedObject object, boolean compareMetadata) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, compareMetadata)) {
            DefaultPrimeMeridian that = (DefaultPrimeMeridian)object;
            if (compareMetadata) {
                return Utilities.equals(this.greenwichLongitude, that.greenwichLongitude) && Utilities.equals(this.angularUnit, that.angularUnit);
            }
            return Utilities.equals(this.getGreenwichLongitude(NonSI.DEGREE_ANGLE), that.getGreenwichLongitude(NonSI.DEGREE_ANGLE));
        }
        return false;
    }

    @Override
    public int hashCode() {
        long code = Double.doubleToLongBits(this.greenwichLongitude);
        return (int)(code >>> 32) ^ (int)code ^ 0x70EC83F9;
    }
}

