/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.CellValueRecordInterface;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.StandardRecord;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndianOutput;

public final class BlankRecord
extends StandardRecord
implements CellValueRecordInterface {
    public static final short sid = 513;
    private int field_1_row;
    private short field_2_col;
    private short field_3_xf;

    public BlankRecord() {
    }

    public BlankRecord(RecordInputStream recordInputStream) {
        this.field_1_row = recordInputStream.readUShort();
        this.field_2_col = recordInputStream.readShort();
        this.field_3_xf = recordInputStream.readShort();
    }

    @Override
    public void setRow(int n) {
        this.field_1_row = n;
    }

    @Override
    public int getRow() {
        return this.field_1_row;
    }

    @Override
    public short getColumn() {
        return this.field_2_col;
    }

    @Override
    public void setXFIndex(short s) {
        this.field_3_xf = s;
    }

    @Override
    public short getXFIndex() {
        return this.field_3_xf;
    }

    @Override
    public void setColumn(short s) {
        this.field_2_col = s;
    }

    @Override
    public short getSid() {
        return 513;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[BLANK]\n");
        stringBuffer.append("    row= ").append(HexDump.shortToHex(this.getRow())).append("\n");
        stringBuffer.append("    col= ").append(HexDump.shortToHex(this.getColumn())).append("\n");
        stringBuffer.append("    xf = ").append(HexDump.shortToHex(this.getXFIndex())).append("\n");
        stringBuffer.append("[/BLANK]\n");
        return stringBuffer.toString();
    }

    @Override
    public void serialize(LittleEndianOutput littleEndianOutput) {
        littleEndianOutput.writeShort(this.getRow());
        littleEndianOutput.writeShort(this.getColumn());
        littleEndianOutput.writeShort(this.getXFIndex());
    }

    @Override
    protected int getDataSize() {
        return 6;
    }

    @Override
    public Object clone() {
        BlankRecord blankRecord = new BlankRecord();
        blankRecord.field_1_row = this.field_1_row;
        blankRecord.field_2_col = this.field_2_col;
        blankRecord.field_3_xf = this.field_3_xf;
        return blankRecord;
    }
}

