/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.modules.fr.toulouse.datasets.urbanisme;

import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.plugins.opendata.modules.fr.toulouse.datasets.ToulouseDataSetHandler;

public class SanisetteHandler
extends ToulouseDataSetHandler {
    public SanisetteHandler() {
        super(12584, "amenity=toilets");
        this.setWikiPage("Sanisettes");
        this.setCategory(CAT_URBANISME);
    }

    public boolean acceptsFilename(String filename) {
        return this.acceptsCsvKmzTabFilename(filename, new String[]{"Sanisette"});
    }

    public void updateDataSet(DataSet ds) {
        for (Node n : ds.getNodes()) {
            n.remove("name");
            n.put("amenity", "toilets");
            n.put("supervised", "no");
            n.put("unisex", "yes");
            n.put("fee", "no");
            n.put("operator", "JCDecaux");
            n.put("opening_hours", "24/7");
            this.replace((IPrimitive)n, "numero", "ref:grandtoulouse");
            this.replace((IPrimitive)n, "PMR", "wheelchair", new String[]{"true", "false"}, new String[]{"yes", "no"});
            String valide = n.get("emplacement_valide");
            if (valide != null && valide.equalsIgnoreCase("non")) {
                n.put("fixme", "L'emplacement semble invalide !");
            } else {
                n.remove("emplacement_valide");
            }
            n.remove("adresse");
            n.remove("INSEE");
            n.remove("color");
        }
    }
}

